package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteInstanceProfileResponse(
    instanceProfile: Optional[zio.aws.databasemigration.model.InstanceProfile] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DeleteInstanceProfileResponse = {
    import DeleteInstanceProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DeleteInstanceProfileResponse
      .builder()
      .optionallyWith(instanceProfile.map(value => value.buildAwsValue()))(
        _.instanceProfile
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DeleteInstanceProfileResponse.ReadOnly =
    zio.aws.databasemigration.model.DeleteInstanceProfileResponse
      .wrap(buildAwsValue())
}
object DeleteInstanceProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DeleteInstanceProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DeleteInstanceProfileResponse =
      zio.aws.databasemigration.model.DeleteInstanceProfileResponse(
        instanceProfile.map(value => value.asEditable)
      )
    def instanceProfile
        : Optional[zio.aws.databasemigration.model.InstanceProfile.ReadOnly]
    def getInstanceProfile: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.InstanceProfile.ReadOnly
    ] = AwsError.unwrapOptionField("instanceProfile", instanceProfile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DeleteInstanceProfileResponse
  ) extends zio.aws.databasemigration.model.DeleteInstanceProfileResponse.ReadOnly {
    override val instanceProfile
        : Optional[zio.aws.databasemigration.model.InstanceProfile.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceProfile())
        .map(value =>
          zio.aws.databasemigration.model.InstanceProfile.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DeleteInstanceProfileResponse
  ): zio.aws.databasemigration.model.DeleteInstanceProfileResponse.ReadOnly =
    new Wrapper(impl)
}
