package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ExportMetadataModelAssessmentResultEntry(
    s3ObjectKey: Optional[String] = Optional.Absent,
    objectURL: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ExportMetadataModelAssessmentResultEntry = {
    import ExportMetadataModelAssessmentResultEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ExportMetadataModelAssessmentResultEntry
      .builder()
      .optionallyWith(s3ObjectKey.map(value => value: java.lang.String))(
        _.s3ObjectKey
      )
      .optionallyWith(objectURL.map(value => value: java.lang.String))(
        _.objectURL
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ExportMetadataModelAssessmentResultEntry.ReadOnly =
    zio.aws.databasemigration.model.ExportMetadataModelAssessmentResultEntry
      .wrap(buildAwsValue())
}
object ExportMetadataModelAssessmentResultEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ExportMetadataModelAssessmentResultEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.ExportMetadataModelAssessmentResultEntry =
      zio.aws.databasemigration.model.ExportMetadataModelAssessmentResultEntry(
        s3ObjectKey.map(value => value),
        objectURL.map(value => value)
      )
    def s3ObjectKey: Optional[String]
    def objectURL: Optional[String]
    def getS3ObjectKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3ObjectKey", s3ObjectKey)
    def getObjectURL: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("objectURL", objectURL)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ExportMetadataModelAssessmentResultEntry
  ) extends zio.aws.databasemigration.model.ExportMetadataModelAssessmentResultEntry.ReadOnly {
    override val s3ObjectKey: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.s3ObjectKey())
      .map(value => value: String)
    override val objectURL: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.objectURL())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ExportMetadataModelAssessmentResultEntry
  ): zio.aws.databasemigration.model.ExportMetadataModelAssessmentResultEntry.ReadOnly =
    new Wrapper(impl)
}
