package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeMigrationProjectsResponse(
    marker: Optional[String] = Optional.Absent,
    migrationProjects: Optional[
      Iterable[zio.aws.databasemigration.model.MigrationProject]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeMigrationProjectsResponse = {
    import DescribeMigrationProjectsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeMigrationProjectsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        migrationProjects.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.migrationProjects)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeMigrationProjectsResponse.ReadOnly =
    zio.aws.databasemigration.model.DescribeMigrationProjectsResponse
      .wrap(buildAwsValue())
}
object DescribeMigrationProjectsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeMigrationProjectsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeMigrationProjectsResponse =
      zio.aws.databasemigration.model.DescribeMigrationProjectsResponse(
        marker.map(value => value),
        migrationProjects.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def migrationProjects: Optional[
      List[zio.aws.databasemigration.model.MigrationProject.ReadOnly]
    ]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMigrationProjects: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.MigrationProject.ReadOnly
    ]] = AwsError.unwrapOptionField("migrationProjects", migrationProjects)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeMigrationProjectsResponse
  ) extends zio.aws.databasemigration.model.DescribeMigrationProjectsResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val migrationProjects: Optional[
      List[zio.aws.databasemigration.model.MigrationProject.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.migrationProjects())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.MigrationProject.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeMigrationProjectsResponse
  ): zio.aws.databasemigration.model.DescribeMigrationProjectsResponse.ReadOnly =
    new Wrapper(impl)
}
