package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DataProviderSettings(
    redshiftSettings: Optional[
      zio.aws.databasemigration.model.RedshiftDataProviderSettings
    ] = Optional.Absent,
    postgreSqlSettings: Optional[
      zio.aws.databasemigration.model.PostgreSqlDataProviderSettings
    ] = Optional.Absent,
    mySqlSettings: Optional[
      zio.aws.databasemigration.model.MySqlDataProviderSettings
    ] = Optional.Absent,
    oracleSettings: Optional[
      zio.aws.databasemigration.model.OracleDataProviderSettings
    ] = Optional.Absent,
    microsoftSqlServerSettings: Optional[
      zio.aws.databasemigration.model.MicrosoftSqlServerDataProviderSettings
    ] = Optional.Absent,
    docDbSettings: Optional[
      zio.aws.databasemigration.model.DocDbDataProviderSettings
    ] = Optional.Absent,
    mariaDbSettings: Optional[
      zio.aws.databasemigration.model.MariaDbDataProviderSettings
    ] = Optional.Absent,
    mongoDbSettings: Optional[
      zio.aws.databasemigration.model.MongoDbDataProviderSettings
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DataProviderSettings = {
    import DataProviderSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DataProviderSettings
      .builder()
      .optionallyWith(redshiftSettings.map(value => value.buildAwsValue()))(
        _.redshiftSettings
      )
      .optionallyWith(postgreSqlSettings.map(value => value.buildAwsValue()))(
        _.postgreSqlSettings
      )
      .optionallyWith(mySqlSettings.map(value => value.buildAwsValue()))(
        _.mySqlSettings
      )
      .optionallyWith(oracleSettings.map(value => value.buildAwsValue()))(
        _.oracleSettings
      )
      .optionallyWith(
        microsoftSqlServerSettings.map(value => value.buildAwsValue())
      )(_.microsoftSqlServerSettings)
      .optionallyWith(docDbSettings.map(value => value.buildAwsValue()))(
        _.docDbSettings
      )
      .optionallyWith(mariaDbSettings.map(value => value.buildAwsValue()))(
        _.mariaDbSettings
      )
      .optionallyWith(mongoDbSettings.map(value => value.buildAwsValue()))(
        _.mongoDbSettings
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DataProviderSettings.ReadOnly =
    zio.aws.databasemigration.model.DataProviderSettings.wrap(buildAwsValue())
}
object DataProviderSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DataProviderSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.DataProviderSettings =
      zio.aws.databasemigration.model.DataProviderSettings(
        redshiftSettings.map(value => value.asEditable),
        postgreSqlSettings.map(value => value.asEditable),
        mySqlSettings.map(value => value.asEditable),
        oracleSettings.map(value => value.asEditable),
        microsoftSqlServerSettings.map(value => value.asEditable),
        docDbSettings.map(value => value.asEditable),
        mariaDbSettings.map(value => value.asEditable),
        mongoDbSettings.map(value => value.asEditable)
      )
    def redshiftSettings: Optional[
      zio.aws.databasemigration.model.RedshiftDataProviderSettings.ReadOnly
    ]
    def postgreSqlSettings: Optional[
      zio.aws.databasemigration.model.PostgreSqlDataProviderSettings.ReadOnly
    ]
    def mySqlSettings: Optional[
      zio.aws.databasemigration.model.MySqlDataProviderSettings.ReadOnly
    ]
    def oracleSettings: Optional[
      zio.aws.databasemigration.model.OracleDataProviderSettings.ReadOnly
    ]
    def microsoftSqlServerSettings: Optional[
      zio.aws.databasemigration.model.MicrosoftSqlServerDataProviderSettings.ReadOnly
    ]
    def docDbSettings: Optional[
      zio.aws.databasemigration.model.DocDbDataProviderSettings.ReadOnly
    ]
    def mariaDbSettings: Optional[
      zio.aws.databasemigration.model.MariaDbDataProviderSettings.ReadOnly
    ]
    def mongoDbSettings: Optional[
      zio.aws.databasemigration.model.MongoDbDataProviderSettings.ReadOnly
    ]
    def getRedshiftSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.RedshiftDataProviderSettings.ReadOnly
    ] = AwsError.unwrapOptionField("redshiftSettings", redshiftSettings)
    def getPostgreSqlSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.PostgreSqlDataProviderSettings.ReadOnly
    ] = AwsError.unwrapOptionField("postgreSqlSettings", postgreSqlSettings)
    def getMySqlSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.MySqlDataProviderSettings.ReadOnly
    ] = AwsError.unwrapOptionField("mySqlSettings", mySqlSettings)
    def getOracleSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.OracleDataProviderSettings.ReadOnly
    ] = AwsError.unwrapOptionField("oracleSettings", oracleSettings)
    def getMicrosoftSqlServerSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.MicrosoftSqlServerDataProviderSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "microsoftSqlServerSettings",
      microsoftSqlServerSettings
    )
    def getDocDbSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.DocDbDataProviderSettings.ReadOnly
    ] = AwsError.unwrapOptionField("docDbSettings", docDbSettings)
    def getMariaDbSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.MariaDbDataProviderSettings.ReadOnly
    ] = AwsError.unwrapOptionField("mariaDbSettings", mariaDbSettings)
    def getMongoDbSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.MongoDbDataProviderSettings.ReadOnly
    ] = AwsError.unwrapOptionField("mongoDbSettings", mongoDbSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DataProviderSettings
  ) extends zio.aws.databasemigration.model.DataProviderSettings.ReadOnly {
    override val redshiftSettings: Optional[
      zio.aws.databasemigration.model.RedshiftDataProviderSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.redshiftSettings())
      .map(value =>
        zio.aws.databasemigration.model.RedshiftDataProviderSettings.wrap(value)
      )
    override val postgreSqlSettings: Optional[
      zio.aws.databasemigration.model.PostgreSqlDataProviderSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.postgreSqlSettings())
      .map(value =>
        zio.aws.databasemigration.model.PostgreSqlDataProviderSettings
          .wrap(value)
      )
    override val mySqlSettings: Optional[
      zio.aws.databasemigration.model.MySqlDataProviderSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.mySqlSettings())
      .map(value =>
        zio.aws.databasemigration.model.MySqlDataProviderSettings.wrap(value)
      )
    override val oracleSettings: Optional[
      zio.aws.databasemigration.model.OracleDataProviderSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.oracleSettings())
      .map(value =>
        zio.aws.databasemigration.model.OracleDataProviderSettings.wrap(value)
      )
    override val microsoftSqlServerSettings: Optional[
      zio.aws.databasemigration.model.MicrosoftSqlServerDataProviderSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.microsoftSqlServerSettings())
      .map(value =>
        zio.aws.databasemigration.model.MicrosoftSqlServerDataProviderSettings
          .wrap(value)
      )
    override val docDbSettings: Optional[
      zio.aws.databasemigration.model.DocDbDataProviderSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.docDbSettings())
      .map(value =>
        zio.aws.databasemigration.model.DocDbDataProviderSettings.wrap(value)
      )
    override val mariaDbSettings: Optional[
      zio.aws.databasemigration.model.MariaDbDataProviderSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.mariaDbSettings())
      .map(value =>
        zio.aws.databasemigration.model.MariaDbDataProviderSettings.wrap(value)
      )
    override val mongoDbSettings: Optional[
      zio.aws.databasemigration.model.MongoDbDataProviderSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.mongoDbSettings())
      .map(value =>
        zio.aws.databasemigration.model.MongoDbDataProviderSettings.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DataProviderSettings
  ): zio.aws.databasemigration.model.DataProviderSettings.ReadOnly =
    new Wrapper(impl)
}
