package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Connection(
    replicationInstanceArn: Optional[String] = Optional.Absent,
    endpointArn: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    lastFailureMessage: Optional[String] = Optional.Absent,
    endpointIdentifier: Optional[String] = Optional.Absent,
    replicationInstanceIdentifier: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.Connection = {
    import Connection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.Connection
      .builder()
      .optionallyWith(
        replicationInstanceArn.map(value => value: java.lang.String)
      )(_.replicationInstanceArn)
      .optionallyWith(endpointArn.map(value => value: java.lang.String))(
        _.endpointArn
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(lastFailureMessage.map(value => value: java.lang.String))(
        _.lastFailureMessage
      )
      .optionallyWith(endpointIdentifier.map(value => value: java.lang.String))(
        _.endpointIdentifier
      )
      .optionallyWith(
        replicationInstanceIdentifier.map(value => value: java.lang.String)
      )(_.replicationInstanceIdentifier)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.Connection.ReadOnly =
    zio.aws.databasemigration.model.Connection.wrap(buildAwsValue())
}
object Connection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.Connection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.Connection =
      zio.aws.databasemigration.model.Connection(
        replicationInstanceArn.map(value => value),
        endpointArn.map(value => value),
        status.map(value => value),
        lastFailureMessage.map(value => value),
        endpointIdentifier.map(value => value),
        replicationInstanceIdentifier.map(value => value)
      )
    def replicationInstanceArn: Optional[String]
    def endpointArn: Optional[String]
    def status: Optional[String]
    def lastFailureMessage: Optional[String]
    def endpointIdentifier: Optional[String]
    def replicationInstanceIdentifier: Optional[String]
    def getReplicationInstanceArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("replicationInstanceArn", replicationInstanceArn)
    def getEndpointArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpointArn", endpointArn)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getLastFailureMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastFailureMessage", lastFailureMessage)
    def getEndpointIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpointIdentifier", endpointIdentifier)
    def getReplicationInstanceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "replicationInstanceIdentifier",
        replicationInstanceIdentifier
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.Connection
  ) extends zio.aws.databasemigration.model.Connection.ReadOnly {
    override val replicationInstanceArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationInstanceArn())
        .map(value => value: String)
    override val endpointArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointArn())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val lastFailureMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.lastFailureMessage())
      .map(value => value: String)
    override val endpointIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointIdentifier())
      .map(value => value: String)
    override val replicationInstanceIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationInstanceIdentifier())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.Connection
  ): zio.aws.databasemigration.model.Connection.ReadOnly = new Wrapper(impl)
}
