package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.Iso8601DateTime
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class MigrationProject(
    migrationProjectName: Optional[String] = Optional.Absent,
    migrationProjectArn: Optional[String] = Optional.Absent,
    migrationProjectCreationTime: Optional[Iso8601DateTime] = Optional.Absent,
    sourceDataProviderDescriptors: Optional[
      Iterable[zio.aws.databasemigration.model.DataProviderDescriptor]
    ] = Optional.Absent,
    targetDataProviderDescriptors: Optional[
      Iterable[zio.aws.databasemigration.model.DataProviderDescriptor]
    ] = Optional.Absent,
    instanceProfileArn: Optional[String] = Optional.Absent,
    instanceProfileName: Optional[String] = Optional.Absent,
    transformationRules: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    schemaConversionApplicationAttributes: Optional[
      zio.aws.databasemigration.model.SCApplicationAttributes
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.MigrationProject = {
    import MigrationProject.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.MigrationProject
      .builder()
      .optionallyWith(
        migrationProjectName.map(value => value: java.lang.String)
      )(_.migrationProjectName)
      .optionallyWith(
        migrationProjectArn.map(value => value: java.lang.String)
      )(_.migrationProjectArn)
      .optionallyWith(
        migrationProjectCreationTime.map(value =>
          Iso8601DateTime.unwrap(value): Instant
        )
      )(_.migrationProjectCreationTime)
      .optionallyWith(
        sourceDataProviderDescriptors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sourceDataProviderDescriptors)
      .optionallyWith(
        targetDataProviderDescriptors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetDataProviderDescriptors)
      .optionallyWith(instanceProfileArn.map(value => value: java.lang.String))(
        _.instanceProfileArn
      )
      .optionallyWith(
        instanceProfileName.map(value => value: java.lang.String)
      )(_.instanceProfileName)
      .optionallyWith(
        transformationRules.map(value => value: java.lang.String)
      )(_.transformationRules)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        schemaConversionApplicationAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.schemaConversionApplicationAttributes)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.MigrationProject.ReadOnly =
    zio.aws.databasemigration.model.MigrationProject.wrap(buildAwsValue())
}
object MigrationProject {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.MigrationProject
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.MigrationProject =
      zio.aws.databasemigration.model.MigrationProject(
        migrationProjectName.map(value => value),
        migrationProjectArn.map(value => value),
        migrationProjectCreationTime.map(value => value),
        sourceDataProviderDescriptors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        targetDataProviderDescriptors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        instanceProfileArn.map(value => value),
        instanceProfileName.map(value => value),
        transformationRules.map(value => value),
        description.map(value => value),
        schemaConversionApplicationAttributes.map(value => value.asEditable)
      )
    def migrationProjectName: Optional[String]
    def migrationProjectArn: Optional[String]
    def migrationProjectCreationTime: Optional[Iso8601DateTime]
    def sourceDataProviderDescriptors: Optional[
      List[zio.aws.databasemigration.model.DataProviderDescriptor.ReadOnly]
    ]
    def targetDataProviderDescriptors: Optional[
      List[zio.aws.databasemigration.model.DataProviderDescriptor.ReadOnly]
    ]
    def instanceProfileArn: Optional[String]
    def instanceProfileName: Optional[String]
    def transformationRules: Optional[String]
    def description: Optional[String]
    def schemaConversionApplicationAttributes: Optional[
      zio.aws.databasemigration.model.SCApplicationAttributes.ReadOnly
    ]
    def getMigrationProjectName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("migrationProjectName", migrationProjectName)
    def getMigrationProjectArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("migrationProjectArn", migrationProjectArn)
    def getMigrationProjectCreationTime: ZIO[Any, AwsError, Iso8601DateTime] =
      AwsError.unwrapOptionField(
        "migrationProjectCreationTime",
        migrationProjectCreationTime
      )
    def getSourceDataProviderDescriptors: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.DataProviderDescriptor.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "sourceDataProviderDescriptors",
      sourceDataProviderDescriptors
    )
    def getTargetDataProviderDescriptors: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.DataProviderDescriptor.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "targetDataProviderDescriptors",
      targetDataProviderDescriptors
    )
    def getInstanceProfileArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceProfileArn", instanceProfileArn)
    def getInstanceProfileName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceProfileName", instanceProfileName)
    def getTransformationRules: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("transformationRules", transformationRules)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getSchemaConversionApplicationAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.SCApplicationAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "schemaConversionApplicationAttributes",
      schemaConversionApplicationAttributes
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.MigrationProject
  ) extends zio.aws.databasemigration.model.MigrationProject.ReadOnly {
    override val migrationProjectName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.migrationProjectName())
      .map(value => value: String)
    override val migrationProjectArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.migrationProjectArn())
      .map(value => value: String)
    override val migrationProjectCreationTime: Optional[Iso8601DateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.migrationProjectCreationTime())
        .map(value =>
          zio.aws.databasemigration.model.primitives.Iso8601DateTime(value)
        )
    override val sourceDataProviderDescriptors: Optional[
      List[zio.aws.databasemigration.model.DataProviderDescriptor.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceDataProviderDescriptors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.DataProviderDescriptor.wrap(item)
        }.toList
      )
    override val targetDataProviderDescriptors: Optional[
      List[zio.aws.databasemigration.model.DataProviderDescriptor.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.targetDataProviderDescriptors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.DataProviderDescriptor.wrap(item)
        }.toList
      )
    override val instanceProfileArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceProfileArn())
      .map(value => value: String)
    override val instanceProfileName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceProfileName())
      .map(value => value: String)
    override val transformationRules: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.transformationRules())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val schemaConversionApplicationAttributes: Optional[
      zio.aws.databasemigration.model.SCApplicationAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.schemaConversionApplicationAttributes())
      .map(value =>
        zio.aws.databasemigration.model.SCApplicationAttributes.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.MigrationProject
  ): zio.aws.databasemigration.model.MigrationProject.ReadOnly = new Wrapper(
    impl
  )
}
