package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.IntegerOptional
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class MariaDbDataProviderSettings(
    serverName: Optional[String] = Optional.Absent,
    port: Optional[IntegerOptional] = Optional.Absent,
    sslMode: Optional[zio.aws.databasemigration.model.DmsSslModeValue] =
      Optional.Absent,
    certificateArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.MariaDbDataProviderSettings = {
    import MariaDbDataProviderSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.MariaDbDataProviderSettings
      .builder()
      .optionallyWith(serverName.map(value => value: java.lang.String))(
        _.serverName
      )
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(sslMode.map(value => value.unwrap))(_.sslMode)
      .optionallyWith(certificateArn.map(value => value: java.lang.String))(
        _.certificateArn
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.MariaDbDataProviderSettings.ReadOnly =
    zio.aws.databasemigration.model.MariaDbDataProviderSettings
      .wrap(buildAwsValue())
}
object MariaDbDataProviderSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.MariaDbDataProviderSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.MariaDbDataProviderSettings =
      zio.aws.databasemigration.model.MariaDbDataProviderSettings(
        serverName.map(value => value),
        port.map(value => value),
        sslMode.map(value => value),
        certificateArn.map(value => value)
      )
    def serverName: Optional[String]
    def port: Optional[IntegerOptional]
    def sslMode: Optional[zio.aws.databasemigration.model.DmsSslModeValue]
    def certificateArn: Optional[String]
    def getServerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serverName", serverName)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getSslMode
        : ZIO[Any, AwsError, zio.aws.databasemigration.model.DmsSslModeValue] =
      AwsError.unwrapOptionField("sslMode", sslMode)
    def getCertificateArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.MariaDbDataProviderSettings
  ) extends zio.aws.databasemigration.model.MariaDbDataProviderSettings.ReadOnly {
    override val serverName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serverName())
      .map(value => value: String)
    override val port: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: IntegerOptional)
    override val sslMode
        : Optional[zio.aws.databasemigration.model.DmsSslModeValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sslMode())
        .map(value =>
          zio.aws.databasemigration.model.DmsSslModeValue.wrap(value)
        )
    override val certificateArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.MariaDbDataProviderSettings
  ): zio.aws.databasemigration.model.MariaDbDataProviderSettings.ReadOnly =
    new Wrapper(impl)
}
