package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DynamoDbSettings(serviceAccessRoleArn: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DynamoDbSettings = {
    import DynamoDbSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DynamoDbSettings
      .builder()
      .serviceAccessRoleArn(serviceAccessRoleArn: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.DynamoDbSettings.ReadOnly =
    zio.aws.databasemigration.model.DynamoDbSettings.wrap(buildAwsValue())
}
object DynamoDbSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DynamoDbSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.DynamoDbSettings =
      zio.aws.databasemigration.model.DynamoDbSettings(serviceAccessRoleArn)
    def serviceAccessRoleArn: String
    def getServiceAccessRoleArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(serviceAccessRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DynamoDbSettings
  ) extends zio.aws.databasemigration.model.DynamoDbSettings.ReadOnly {
    override val serviceAccessRoleArn: String =
      impl.serviceAccessRoleArn(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DynamoDbSettings
  ): zio.aws.databasemigration.model.DynamoDbSettings.ReadOnly = new Wrapper(
    impl
  )
}
