package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StartMetadataModelConversionRequest(
    migrationProjectIdentifier: String,
    selectionRules: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.StartMetadataModelConversionRequest = {
    import StartMetadataModelConversionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.StartMetadataModelConversionRequest
      .builder()
      .migrationProjectIdentifier(migrationProjectIdentifier: java.lang.String)
      .selectionRules(selectionRules: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.StartMetadataModelConversionRequest.ReadOnly =
    zio.aws.databasemigration.model.StartMetadataModelConversionRequest
      .wrap(buildAwsValue())
}
object StartMetadataModelConversionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.StartMetadataModelConversionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.StartMetadataModelConversionRequest =
      zio.aws.databasemigration.model.StartMetadataModelConversionRequest(
        migrationProjectIdentifier,
        selectionRules
      )
    def migrationProjectIdentifier: String
    def selectionRules: String
    def getMigrationProjectIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(migrationProjectIdentifier)
    def getSelectionRules: ZIO[Any, Nothing, String] =
      ZIO.succeed(selectionRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.StartMetadataModelConversionRequest
  ) extends zio.aws.databasemigration.model.StartMetadataModelConversionRequest.ReadOnly {
    override val migrationProjectIdentifier: String =
      impl.migrationProjectIdentifier(): String
    override val selectionRules: String = impl.selectionRules(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.StartMetadataModelConversionRequest
  ): zio.aws.databasemigration.model.StartMetadataModelConversionRequest.ReadOnly =
    new Wrapper(impl)
}
