package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.TStamp
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class StartReplicationRequest(
    replicationConfigArn: String,
    startReplicationType: String,
    cdcStartTime: Optional[TStamp] = Optional.Absent,
    cdcStartPosition: Optional[String] = Optional.Absent,
    cdcStopPosition: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.StartReplicationRequest = {
    import StartReplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.StartReplicationRequest
      .builder()
      .replicationConfigArn(replicationConfigArn: java.lang.String)
      .startReplicationType(startReplicationType: java.lang.String)
      .optionallyWith(cdcStartTime.map(value => TStamp.unwrap(value): Instant))(
        _.cdcStartTime
      )
      .optionallyWith(cdcStartPosition.map(value => value: java.lang.String))(
        _.cdcStartPosition
      )
      .optionallyWith(cdcStopPosition.map(value => value: java.lang.String))(
        _.cdcStopPosition
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.StartReplicationRequest.ReadOnly =
    zio.aws.databasemigration.model.StartReplicationRequest
      .wrap(buildAwsValue())
}
object StartReplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.StartReplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.StartReplicationRequest =
      zio.aws.databasemigration.model.StartReplicationRequest(
        replicationConfigArn,
        startReplicationType,
        cdcStartTime.map(value => value),
        cdcStartPosition.map(value => value),
        cdcStopPosition.map(value => value)
      )
    def replicationConfigArn: String
    def startReplicationType: String
    def cdcStartTime: Optional[TStamp]
    def cdcStartPosition: Optional[String]
    def cdcStopPosition: Optional[String]
    def getReplicationConfigArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationConfigArn)
    def getStartReplicationType: ZIO[Any, Nothing, String] =
      ZIO.succeed(startReplicationType)
    def getCdcStartTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("cdcStartTime", cdcStartTime)
    def getCdcStartPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cdcStartPosition", cdcStartPosition)
    def getCdcStopPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cdcStopPosition", cdcStopPosition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.StartReplicationRequest
  ) extends zio.aws.databasemigration.model.StartReplicationRequest.ReadOnly {
    override val replicationConfigArn: String =
      impl.replicationConfigArn(): String
    override val startReplicationType: String =
      impl.startReplicationType(): String
    override val cdcStartTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.cdcStartTime())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val cdcStartPosition: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cdcStartPosition())
      .map(value => value: String)
    override val cdcStopPosition: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cdcStopPosition())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.StartReplicationRequest
  ): zio.aws.databasemigration.model.StartReplicationRequest.ReadOnly =
    new Wrapper(impl)
}
