package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteDataProviderRequest(dataProviderIdentifier: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DeleteDataProviderRequest = {
    import DeleteDataProviderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DeleteDataProviderRequest
      .builder()
      .dataProviderIdentifier(dataProviderIdentifier: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DeleteDataProviderRequest.ReadOnly =
    zio.aws.databasemigration.model.DeleteDataProviderRequest
      .wrap(buildAwsValue())
}
object DeleteDataProviderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DeleteDataProviderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.DeleteDataProviderRequest =
      zio.aws.databasemigration.model
        .DeleteDataProviderRequest(dataProviderIdentifier)
    def dataProviderIdentifier: String
    def getDataProviderIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dataProviderIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DeleteDataProviderRequest
  ) extends zio.aws.databasemigration.model.DeleteDataProviderRequest.ReadOnly {
    override val dataProviderIdentifier: String =
      impl.dataProviderIdentifier(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DeleteDataProviderRequest
  ): zio.aws.databasemigration.model.DeleteDataProviderRequest.ReadOnly =
    new Wrapper(impl)
}
