package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchStartRecommendationsRequest(
    data: Optional[
      Iterable[zio.aws.databasemigration.model.StartRecommendationsRequestEntry]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.BatchStartRecommendationsRequest = {
    import BatchStartRecommendationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.BatchStartRecommendationsRequest
      .builder()
      .optionallyWith(
        data.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.data)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.BatchStartRecommendationsRequest.ReadOnly =
    zio.aws.databasemigration.model.BatchStartRecommendationsRequest
      .wrap(buildAwsValue())
}
object BatchStartRecommendationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.BatchStartRecommendationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.BatchStartRecommendationsRequest =
      zio.aws.databasemigration.model.BatchStartRecommendationsRequest(
        data.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def data: Optional[List[
      zio.aws.databasemigration.model.StartRecommendationsRequestEntry.ReadOnly
    ]]
    def getData: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.StartRecommendationsRequestEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("data", data)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.BatchStartRecommendationsRequest
  ) extends zio.aws.databasemigration.model.BatchStartRecommendationsRequest.ReadOnly {
    override val data: Optional[List[
      zio.aws.databasemigration.model.StartRecommendationsRequestEntry.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.data())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.StartRecommendationsRequestEntry
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.BatchStartRecommendationsRequest
  ): zio.aws.databasemigration.model.BatchStartRecommendationsRequest.ReadOnly =
    new Wrapper(impl)
}
