package zio.aws.databasemigration.model
import scala.jdk.CollectionConverters._
sealed trait DmsSslModeValue {
  def unwrap
      : software.amazon.awssdk.services.databasemigration.model.DmsSslModeValue
}
object DmsSslModeValue {
  def wrap(
      value: software.amazon.awssdk.services.databasemigration.model.DmsSslModeValue
  ): zio.aws.databasemigration.model.DmsSslModeValue = value match {
    case software.amazon.awssdk.services.databasemigration.model.DmsSslModeValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databasemigration.model.DmsSslModeValue.NONE =>
      val r = none
      r
    case software.amazon.awssdk.services.databasemigration.model.DmsSslModeValue.REQUIRE =>
      val r = require
      r
    case software.amazon.awssdk.services.databasemigration.model.DmsSslModeValue.VERIFY_CA =>
      val r = `verify-ca`
      r
    case software.amazon.awssdk.services.databasemigration.model.DmsSslModeValue.VERIFY_FULL =>
      val r = `verify-full`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.databasemigration.model.DmsSslModeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.DmsSslModeValue =
      software.amazon.awssdk.services.databasemigration.model.DmsSslModeValue.UNKNOWN_TO_SDK_VERSION
  }
  case object none extends zio.aws.databasemigration.model.DmsSslModeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.DmsSslModeValue =
      software.amazon.awssdk.services.databasemigration.model.DmsSslModeValue.NONE
  }
  case object require extends zio.aws.databasemigration.model.DmsSslModeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.DmsSslModeValue =
      software.amazon.awssdk.services.databasemigration.model.DmsSslModeValue.REQUIRE
  }
  case object `verify-ca`
      extends zio.aws.databasemigration.model.DmsSslModeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.DmsSslModeValue =
      software.amazon.awssdk.services.databasemigration.model.DmsSslModeValue.VERIFY_CA
  }
  case object `verify-full`
      extends zio.aws.databasemigration.model.DmsSslModeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.DmsSslModeValue =
      software.amazon.awssdk.services.databasemigration.model.DmsSslModeValue.VERIFY_FULL
  }
}
