package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchStartRecommendationsResponse(
    errorEntries: Optional[Iterable[
      zio.aws.databasemigration.model.BatchStartRecommendationsErrorEntry
    ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.BatchStartRecommendationsResponse = {
    import BatchStartRecommendationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.BatchStartRecommendationsResponse
      .builder()
      .optionallyWith(
        errorEntries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errorEntries)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.BatchStartRecommendationsResponse.ReadOnly =
    zio.aws.databasemigration.model.BatchStartRecommendationsResponse
      .wrap(buildAwsValue())
}
object BatchStartRecommendationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.BatchStartRecommendationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.BatchStartRecommendationsResponse =
      zio.aws.databasemigration.model.BatchStartRecommendationsResponse(
        errorEntries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def errorEntries: Optional[List[
      zio.aws.databasemigration.model.BatchStartRecommendationsErrorEntry.ReadOnly
    ]]
    def getErrorEntries: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.BatchStartRecommendationsErrorEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("errorEntries", errorEntries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.BatchStartRecommendationsResponse
  ) extends zio.aws.databasemigration.model.BatchStartRecommendationsResponse.ReadOnly {
    override val errorEntries: Optional[List[
      zio.aws.databasemigration.model.BatchStartRecommendationsErrorEntry.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.errorEntries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.BatchStartRecommendationsErrorEntry
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.BatchStartRecommendationsResponse
  ): zio.aws.databasemigration.model.BatchStartRecommendationsResponse.ReadOnly =
    new Wrapper(impl)
}
