package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.{TStamp, Integer}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ReplicationTaskStats(
    fullLoadProgressPercent: Optional[Integer] = Optional.Absent,
    elapsedTimeMillis: Optional[Long] = Optional.Absent,
    tablesLoaded: Optional[Integer] = Optional.Absent,
    tablesLoading: Optional[Integer] = Optional.Absent,
    tablesQueued: Optional[Integer] = Optional.Absent,
    tablesErrored: Optional[Integer] = Optional.Absent,
    freshStartDate: Optional[TStamp] = Optional.Absent,
    startDate: Optional[TStamp] = Optional.Absent,
    stopDate: Optional[TStamp] = Optional.Absent,
    fullLoadStartDate: Optional[TStamp] = Optional.Absent,
    fullLoadFinishDate: Optional[TStamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ReplicationTaskStats = {
    import ReplicationTaskStats.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ReplicationTaskStats
      .builder()
      .optionallyWith(
        fullLoadProgressPercent.map(value => value: java.lang.Integer)
      )(_.fullLoadProgressPercent)
      .optionallyWith(elapsedTimeMillis.map(value => value: java.lang.Long))(
        _.elapsedTimeMillis
      )
      .optionallyWith(tablesLoaded.map(value => value: java.lang.Integer))(
        _.tablesLoaded
      )
      .optionallyWith(tablesLoading.map(value => value: java.lang.Integer))(
        _.tablesLoading
      )
      .optionallyWith(tablesQueued.map(value => value: java.lang.Integer))(
        _.tablesQueued
      )
      .optionallyWith(tablesErrored.map(value => value: java.lang.Integer))(
        _.tablesErrored
      )
      .optionallyWith(
        freshStartDate.map(value => TStamp.unwrap(value): Instant)
      )(_.freshStartDate)
      .optionallyWith(startDate.map(value => TStamp.unwrap(value): Instant))(
        _.startDate
      )
      .optionallyWith(stopDate.map(value => TStamp.unwrap(value): Instant))(
        _.stopDate
      )
      .optionallyWith(
        fullLoadStartDate.map(value => TStamp.unwrap(value): Instant)
      )(_.fullLoadStartDate)
      .optionallyWith(
        fullLoadFinishDate.map(value => TStamp.unwrap(value): Instant)
      )(_.fullLoadFinishDate)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ReplicationTaskStats.ReadOnly =
    zio.aws.databasemigration.model.ReplicationTaskStats.wrap(buildAwsValue())
}
object ReplicationTaskStats {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ReplicationTaskStats
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.ReplicationTaskStats =
      zio.aws.databasemigration.model.ReplicationTaskStats(
        fullLoadProgressPercent.map(value => value),
        elapsedTimeMillis.map(value => value),
        tablesLoaded.map(value => value),
        tablesLoading.map(value => value),
        tablesQueued.map(value => value),
        tablesErrored.map(value => value),
        freshStartDate.map(value => value),
        startDate.map(value => value),
        stopDate.map(value => value),
        fullLoadStartDate.map(value => value),
        fullLoadFinishDate.map(value => value)
      )
    def fullLoadProgressPercent: Optional[Integer]
    def elapsedTimeMillis: Optional[Long]
    def tablesLoaded: Optional[Integer]
    def tablesLoading: Optional[Integer]
    def tablesQueued: Optional[Integer]
    def tablesErrored: Optional[Integer]
    def freshStartDate: Optional[TStamp]
    def startDate: Optional[TStamp]
    def stopDate: Optional[TStamp]
    def fullLoadStartDate: Optional[TStamp]
    def fullLoadFinishDate: Optional[TStamp]
    def getFullLoadProgressPercent: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("fullLoadProgressPercent", fullLoadProgressPercent)
    def getElapsedTimeMillis: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("elapsedTimeMillis", elapsedTimeMillis)
    def getTablesLoaded: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("tablesLoaded", tablesLoaded)
    def getTablesLoading: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("tablesLoading", tablesLoading)
    def getTablesQueued: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("tablesQueued", tablesQueued)
    def getTablesErrored: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("tablesErrored", tablesErrored)
    def getFreshStartDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("freshStartDate", freshStartDate)
    def getStartDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("startDate", startDate)
    def getStopDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("stopDate", stopDate)
    def getFullLoadStartDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("fullLoadStartDate", fullLoadStartDate)
    def getFullLoadFinishDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("fullLoadFinishDate", fullLoadFinishDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ReplicationTaskStats
  ) extends zio.aws.databasemigration.model.ReplicationTaskStats.ReadOnly {
    override val fullLoadProgressPercent: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fullLoadProgressPercent())
        .map(value => value: Integer)
    override val elapsedTimeMillis: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.elapsedTimeMillis())
      .map(value => value: Long)
    override val tablesLoaded: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.tablesLoaded())
      .map(value => value: Integer)
    override val tablesLoading: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.tablesLoading())
      .map(value => value: Integer)
    override val tablesQueued: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.tablesQueued())
      .map(value => value: Integer)
    override val tablesErrored: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.tablesErrored())
      .map(value => value: Integer)
    override val freshStartDate: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.freshStartDate())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val startDate: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startDate())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val stopDate: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.stopDate())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val fullLoadStartDate: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.fullLoadStartDate())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val fullLoadFinishDate: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.fullLoadFinishDate())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ReplicationTaskStats
  ): zio.aws.databasemigration.model.ReplicationTaskStats.ReadOnly =
    new Wrapper(impl)
}
