package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.{
  IntegerOptional,
  DoubleOptional
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class RdsConfiguration(
    engineEdition: Optional[String] = Optional.Absent,
    instanceType: Optional[String] = Optional.Absent,
    instanceVcpu: Optional[DoubleOptional] = Optional.Absent,
    instanceMemory: Optional[DoubleOptional] = Optional.Absent,
    storageType: Optional[String] = Optional.Absent,
    storageSize: Optional[IntegerOptional] = Optional.Absent,
    storageIops: Optional[IntegerOptional] = Optional.Absent,
    deploymentOption: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.RdsConfiguration = {
    import RdsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.RdsConfiguration
      .builder()
      .optionallyWith(engineEdition.map(value => value: java.lang.String))(
        _.engineEdition
      )
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(instanceVcpu.map(value => value: java.lang.Double))(
        _.instanceVcpu
      )
      .optionallyWith(instanceMemory.map(value => value: java.lang.Double))(
        _.instanceMemory
      )
      .optionallyWith(storageType.map(value => value: java.lang.String))(
        _.storageType
      )
      .optionallyWith(storageSize.map(value => value: Integer))(_.storageSize)
      .optionallyWith(storageIops.map(value => value: Integer))(_.storageIops)
      .optionallyWith(deploymentOption.map(value => value: java.lang.String))(
        _.deploymentOption
      )
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.RdsConfiguration.ReadOnly =
    zio.aws.databasemigration.model.RdsConfiguration.wrap(buildAwsValue())
}
object RdsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.RdsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.RdsConfiguration =
      zio.aws.databasemigration.model.RdsConfiguration(
        engineEdition.map(value => value),
        instanceType.map(value => value),
        instanceVcpu.map(value => value),
        instanceMemory.map(value => value),
        storageType.map(value => value),
        storageSize.map(value => value),
        storageIops.map(value => value),
        deploymentOption.map(value => value)
      )
    def engineEdition: Optional[String]
    def instanceType: Optional[String]
    def instanceVcpu: Optional[DoubleOptional]
    def instanceMemory: Optional[DoubleOptional]
    def storageType: Optional[String]
    def storageSize: Optional[IntegerOptional]
    def storageIops: Optional[IntegerOptional]
    def deploymentOption: Optional[String]
    def getEngineEdition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineEdition", engineEdition)
    def getInstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getInstanceVcpu: ZIO[Any, AwsError, DoubleOptional] =
      AwsError.unwrapOptionField("instanceVcpu", instanceVcpu)
    def getInstanceMemory: ZIO[Any, AwsError, DoubleOptional] =
      AwsError.unwrapOptionField("instanceMemory", instanceMemory)
    def getStorageType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getStorageSize: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("storageSize", storageSize)
    def getStorageIops: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("storageIops", storageIops)
    def getDeploymentOption: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deploymentOption", deploymentOption)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.RdsConfiguration
  ) extends zio.aws.databasemigration.model.RdsConfiguration.ReadOnly {
    override val engineEdition: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineEdition())
      .map(value => value: String)
    override val instanceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceType())
      .map(value => value: String)
    override val instanceVcpu: Optional[DoubleOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceVcpu())
      .map(value => value: DoubleOptional)
    override val instanceMemory: Optional[DoubleOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceMemory())
        .map(value => value: DoubleOptional)
    override val storageType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.storageType())
      .map(value => value: String)
    override val storageSize: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.storageSize())
      .map(value => value: IntegerOptional)
    override val storageIops: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.storageIops())
      .map(value => value: IntegerOptional)
    override val deploymentOption: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.deploymentOption())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.RdsConfiguration
  ): zio.aws.databasemigration.model.RdsConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
