package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImportCertificateResponse(
    certificate: Optional[zio.aws.databasemigration.model.Certificate] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ImportCertificateResponse = {
    import ImportCertificateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ImportCertificateResponse
      .builder()
      .optionallyWith(certificate.map(value => value.buildAwsValue()))(
        _.certificate
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ImportCertificateResponse.ReadOnly =
    zio.aws.databasemigration.model.ImportCertificateResponse
      .wrap(buildAwsValue())
}
object ImportCertificateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ImportCertificateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.ImportCertificateResponse =
      zio.aws.databasemigration.model
        .ImportCertificateResponse(certificate.map(value => value.asEditable))
    def certificate
        : Optional[zio.aws.databasemigration.model.Certificate.ReadOnly]
    def getCertificate: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.Certificate.ReadOnly
    ] = AwsError.unwrapOptionField("certificate", certificate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ImportCertificateResponse
  ) extends zio.aws.databasemigration.model.ImportCertificateResponse.ReadOnly {
    override val certificate
        : Optional[zio.aws.databasemigration.model.Certificate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificate())
        .map(value => zio.aws.databasemigration.model.Certificate.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ImportCertificateResponse
  ): zio.aws.databasemigration.model.ImportCertificateResponse.ReadOnly =
    new Wrapper(impl)
}
