package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeRecommendationsResponse(
    nextToken: Optional[String] = Optional.Absent,
    recommendations: Optional[
      Iterable[zio.aws.databasemigration.model.Recommendation]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationsResponse = {
    import DescribeRecommendationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        recommendations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recommendations)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeRecommendationsResponse.ReadOnly =
    zio.aws.databasemigration.model.DescribeRecommendationsResponse
      .wrap(buildAwsValue())
}
object DescribeRecommendationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeRecommendationsResponse =
      zio.aws.databasemigration.model.DescribeRecommendationsResponse(
        nextToken.map(value => value),
        recommendations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def recommendations: Optional[
      List[zio.aws.databasemigration.model.Recommendation.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRecommendations: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.Recommendation.ReadOnly
    ]] = AwsError.unwrapOptionField("recommendations", recommendations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationsResponse
  ) extends zio.aws.databasemigration.model.DescribeRecommendationsResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val recommendations: Optional[
      List[zio.aws.databasemigration.model.Recommendation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.recommendations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.Recommendation.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationsResponse
  ): zio.aws.databasemigration.model.DescribeRecommendationsResponse.ReadOnly =
    new Wrapper(impl)
}
