package zio.aws.databasemigration.model
import scala.jdk.CollectionConverters._
sealed trait CompressionTypeValue {
  def unwrap: software.amazon.awssdk.services.databasemigration.model.CompressionTypeValue
}
object CompressionTypeValue {
  def wrap(
      value: software.amazon.awssdk.services.databasemigration.model.CompressionTypeValue
  ): zio.aws.databasemigration.model.CompressionTypeValue = value match {
    case software.amazon.awssdk.services.databasemigration.model.CompressionTypeValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databasemigration.model.CompressionTypeValue.NONE =>
      val r = none
      r
    case software.amazon.awssdk.services.databasemigration.model.CompressionTypeValue.GZIP =>
      val r = gzip
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.databasemigration.model.CompressionTypeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.CompressionTypeValue =
      software.amazon.awssdk.services.databasemigration.model.CompressionTypeValue.UNKNOWN_TO_SDK_VERSION
  }
  case object none
      extends zio.aws.databasemigration.model.CompressionTypeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.CompressionTypeValue =
      software.amazon.awssdk.services.databasemigration.model.CompressionTypeValue.NONE
  }
  case object gzip
      extends zio.aws.databasemigration.model.CompressionTypeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.CompressionTypeValue =
      software.amazon.awssdk.services.databasemigration.model.CompressionTypeValue.GZIP
  }
}
