package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyReplicationTaskResponse(
    replicationTask: Optional[zio.aws.databasemigration.model.ReplicationTask] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ModifyReplicationTaskResponse = {
    import ModifyReplicationTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ModifyReplicationTaskResponse
      .builder()
      .optionallyWith(replicationTask.map(value => value.buildAwsValue()))(
        _.replicationTask
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ModifyReplicationTaskResponse.ReadOnly =
    zio.aws.databasemigration.model.ModifyReplicationTaskResponse
      .wrap(buildAwsValue())
}
object ModifyReplicationTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ModifyReplicationTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.ModifyReplicationTaskResponse =
      zio.aws.databasemigration.model.ModifyReplicationTaskResponse(
        replicationTask.map(value => value.asEditable)
      )
    def replicationTask
        : Optional[zio.aws.databasemigration.model.ReplicationTask.ReadOnly]
    def getReplicationTask: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ReplicationTask.ReadOnly
    ] = AwsError.unwrapOptionField("replicationTask", replicationTask)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ModifyReplicationTaskResponse
  ) extends zio.aws.databasemigration.model.ModifyReplicationTaskResponse.ReadOnly {
    override val replicationTask
        : Optional[zio.aws.databasemigration.model.ReplicationTask.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationTask())
        .map(value =>
          zio.aws.databasemigration.model.ReplicationTask.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ModifyReplicationTaskResponse
  ): zio.aws.databasemigration.model.ModifyReplicationTaskResponse.ReadOnly =
    new Wrapper(impl)
}
