package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DatabaseShortInfoResponse(
    databaseId: Optional[String] = Optional.Absent,
    databaseName: Optional[String] = Optional.Absent,
    databaseIpAddress: Optional[String] = Optional.Absent,
    databaseEngine: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DatabaseShortInfoResponse = {
    import DatabaseShortInfoResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DatabaseShortInfoResponse
      .builder()
      .optionallyWith(databaseId.map(value => value: java.lang.String))(
        _.databaseId
      )
      .optionallyWith(databaseName.map(value => value: java.lang.String))(
        _.databaseName
      )
      .optionallyWith(databaseIpAddress.map(value => value: java.lang.String))(
        _.databaseIpAddress
      )
      .optionallyWith(databaseEngine.map(value => value: java.lang.String))(
        _.databaseEngine
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DatabaseShortInfoResponse.ReadOnly =
    zio.aws.databasemigration.model.DatabaseShortInfoResponse
      .wrap(buildAwsValue())
}
object DatabaseShortInfoResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DatabaseShortInfoResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.DatabaseShortInfoResponse =
      zio.aws.databasemigration.model.DatabaseShortInfoResponse(
        databaseId.map(value => value),
        databaseName.map(value => value),
        databaseIpAddress.map(value => value),
        databaseEngine.map(value => value)
      )
    def databaseId: Optional[String]
    def databaseName: Optional[String]
    def databaseIpAddress: Optional[String]
    def databaseEngine: Optional[String]
    def getDatabaseId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseId", databaseId)
    def getDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getDatabaseIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseIpAddress", databaseIpAddress)
    def getDatabaseEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseEngine", databaseEngine)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DatabaseShortInfoResponse
  ) extends zio.aws.databasemigration.model.DatabaseShortInfoResponse.ReadOnly {
    override val databaseId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseId())
      .map(value => value: String)
    override val databaseName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseName())
      .map(value => value: String)
    override val databaseIpAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseIpAddress())
      .map(value => value: String)
    override val databaseEngine: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseEngine())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DatabaseShortInfoResponse
  ): zio.aws.databasemigration.model.DatabaseShortInfoResponse.ReadOnly =
    new Wrapper(impl)
}
