package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartExtensionPackAssociationResponse(
    requestIdentifier: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.StartExtensionPackAssociationResponse = {
    import StartExtensionPackAssociationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.StartExtensionPackAssociationResponse
      .builder()
      .optionallyWith(requestIdentifier.map(value => value: java.lang.String))(
        _.requestIdentifier
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.StartExtensionPackAssociationResponse.ReadOnly =
    zio.aws.databasemigration.model.StartExtensionPackAssociationResponse
      .wrap(buildAwsValue())
}
object StartExtensionPackAssociationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.StartExtensionPackAssociationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.StartExtensionPackAssociationResponse =
      zio.aws.databasemigration.model.StartExtensionPackAssociationResponse(
        requestIdentifier.map(value => value)
      )
    def requestIdentifier: Optional[String]
    def getRequestIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("requestIdentifier", requestIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.StartExtensionPackAssociationResponse
  ) extends zio.aws.databasemigration.model.StartExtensionPackAssociationResponse.ReadOnly {
    override val requestIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.requestIdentifier())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.StartExtensionPackAssociationResponse
  ): zio.aws.databasemigration.model.StartExtensionPackAssociationResponse.ReadOnly =
    new Wrapper(impl)
}
