package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SchemaConversionRequest(
    status: Optional[String] = Optional.Absent,
    requestIdentifier: Optional[String] = Optional.Absent,
    migrationProjectArn: Optional[String] = Optional.Absent,
    error: Optional[zio.aws.databasemigration.model.ErrorDetails] =
      Optional.Absent,
    exportSqlDetails: Optional[
      zio.aws.databasemigration.model.ExportSqlDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.SchemaConversionRequest = {
    import SchemaConversionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.SchemaConversionRequest
      .builder()
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(requestIdentifier.map(value => value: java.lang.String))(
        _.requestIdentifier
      )
      .optionallyWith(
        migrationProjectArn.map(value => value: java.lang.String)
      )(_.migrationProjectArn)
      .optionallyWith(error.map(value => value.buildAwsValue()))(_.error)
      .optionallyWith(exportSqlDetails.map(value => value.buildAwsValue()))(
        _.exportSqlDetails
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.SchemaConversionRequest.ReadOnly =
    zio.aws.databasemigration.model.SchemaConversionRequest
      .wrap(buildAwsValue())
}
object SchemaConversionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.SchemaConversionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.SchemaConversionRequest =
      zio.aws.databasemigration.model.SchemaConversionRequest(
        status.map(value => value),
        requestIdentifier.map(value => value),
        migrationProjectArn.map(value => value),
        error.map(value => value.asEditable),
        exportSqlDetails.map(value => value.asEditable)
      )
    def status: Optional[String]
    def requestIdentifier: Optional[String]
    def migrationProjectArn: Optional[String]
    def error: Optional[zio.aws.databasemigration.model.ErrorDetails.ReadOnly]
    def exportSqlDetails
        : Optional[zio.aws.databasemigration.model.ExportSqlDetails.ReadOnly]
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getRequestIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("requestIdentifier", requestIdentifier)
    def getMigrationProjectArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("migrationProjectArn", migrationProjectArn)
    def getError: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ErrorDetails.ReadOnly
    ] = AwsError.unwrapOptionField("error", error)
    def getExportSqlDetails: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ExportSqlDetails.ReadOnly
    ] = AwsError.unwrapOptionField("exportSqlDetails", exportSqlDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.SchemaConversionRequest
  ) extends zio.aws.databasemigration.model.SchemaConversionRequest.ReadOnly {
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val requestIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.requestIdentifier())
      .map(value => value: String)
    override val migrationProjectArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.migrationProjectArn())
      .map(value => value: String)
    override val error
        : Optional[zio.aws.databasemigration.model.ErrorDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.error())
        .map(value => zio.aws.databasemigration.model.ErrorDetails.wrap(value))
    override val exportSqlDetails
        : Optional[zio.aws.databasemigration.model.ExportSqlDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exportSqlDetails())
        .map(value =>
          zio.aws.databasemigration.model.ExportSqlDetails.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.SchemaConversionRequest
  ): zio.aws.databasemigration.model.SchemaConversionRequest.ReadOnly =
    new Wrapper(impl)
}
