package zio.aws.databasemigration.model
import scala.jdk.CollectionConverters._
sealed trait KafkaSslEndpointIdentificationAlgorithm {
  def unwrap: software.amazon.awssdk.services.databasemigration.model.KafkaSslEndpointIdentificationAlgorithm
}
object KafkaSslEndpointIdentificationAlgorithm {
  def wrap(
      value: software.amazon.awssdk.services.databasemigration.model.KafkaSslEndpointIdentificationAlgorithm
  ): zio.aws.databasemigration.model.KafkaSslEndpointIdentificationAlgorithm =
    value match {
      case software.amazon.awssdk.services.databasemigration.model.KafkaSslEndpointIdentificationAlgorithm.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.databasemigration.model.KafkaSslEndpointIdentificationAlgorithm.NONE =>
        val r = none
        r
      case software.amazon.awssdk.services.databasemigration.model.KafkaSslEndpointIdentificationAlgorithm.HTTPS =>
        val r = https
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.databasemigration.model.KafkaSslEndpointIdentificationAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.KafkaSslEndpointIdentificationAlgorithm =
      software.amazon.awssdk.services.databasemigration.model.KafkaSslEndpointIdentificationAlgorithm.UNKNOWN_TO_SDK_VERSION
  }
  case object none
      extends zio.aws.databasemigration.model.KafkaSslEndpointIdentificationAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.KafkaSslEndpointIdentificationAlgorithm =
      software.amazon.awssdk.services.databasemigration.model.KafkaSslEndpointIdentificationAlgorithm.NONE
  }
  case object https
      extends zio.aws.databasemigration.model.KafkaSslEndpointIdentificationAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.KafkaSslEndpointIdentificationAlgorithm =
      software.amazon.awssdk.services.databasemigration.model.KafkaSslEndpointIdentificationAlgorithm.HTTPS
  }
}
