package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ExportMetadataModelAssessmentResponse(
    pdfReport: Optional[
      zio.aws.databasemigration.model.ExportMetadataModelAssessmentResultEntry
    ] = Optional.Absent,
    csvReport: Optional[
      zio.aws.databasemigration.model.ExportMetadataModelAssessmentResultEntry
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ExportMetadataModelAssessmentResponse = {
    import ExportMetadataModelAssessmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ExportMetadataModelAssessmentResponse
      .builder()
      .optionallyWith(pdfReport.map(value => value.buildAwsValue()))(
        _.pdfReport
      )
      .optionallyWith(csvReport.map(value => value.buildAwsValue()))(
        _.csvReport
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ExportMetadataModelAssessmentResponse.ReadOnly =
    zio.aws.databasemigration.model.ExportMetadataModelAssessmentResponse
      .wrap(buildAwsValue())
}
object ExportMetadataModelAssessmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ExportMetadataModelAssessmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.ExportMetadataModelAssessmentResponse =
      zio.aws.databasemigration.model.ExportMetadataModelAssessmentResponse(
        pdfReport.map(value => value.asEditable),
        csvReport.map(value => value.asEditable)
      )
    def pdfReport: Optional[
      zio.aws.databasemigration.model.ExportMetadataModelAssessmentResultEntry.ReadOnly
    ]
    def csvReport: Optional[
      zio.aws.databasemigration.model.ExportMetadataModelAssessmentResultEntry.ReadOnly
    ]
    def getPdfReport: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ExportMetadataModelAssessmentResultEntry.ReadOnly
    ] = AwsError.unwrapOptionField("pdfReport", pdfReport)
    def getCsvReport: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ExportMetadataModelAssessmentResultEntry.ReadOnly
    ] = AwsError.unwrapOptionField("csvReport", csvReport)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ExportMetadataModelAssessmentResponse
  ) extends zio.aws.databasemigration.model.ExportMetadataModelAssessmentResponse.ReadOnly {
    override val pdfReport: Optional[
      zio.aws.databasemigration.model.ExportMetadataModelAssessmentResultEntry.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.pdfReport())
      .map(value =>
        zio.aws.databasemigration.model.ExportMetadataModelAssessmentResultEntry
          .wrap(value)
      )
    override val csvReport: Optional[
      zio.aws.databasemigration.model.ExportMetadataModelAssessmentResultEntry.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.csvReport())
      .map(value =>
        zio.aws.databasemigration.model.ExportMetadataModelAssessmentResultEntry
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ExportMetadataModelAssessmentResponse
  ): zio.aws.databasemigration.model.ExportMetadataModelAssessmentResponse.ReadOnly =
    new Wrapper(impl)
}
