package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DataProviderSettings(
    postgreSqlSettings: Optional[
      zio.aws.databasemigration.model.PostgreSqlDataProviderSettings
    ] = Optional.Absent,
    mySqlSettings: Optional[
      zio.aws.databasemigration.model.MySqlDataProviderSettings
    ] = Optional.Absent,
    oracleSettings: Optional[
      zio.aws.databasemigration.model.OracleDataProviderSettings
    ] = Optional.Absent,
    microsoftSqlServerSettings: Optional[
      zio.aws.databasemigration.model.MicrosoftSqlServerDataProviderSettings
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DataProviderSettings = {
    import DataProviderSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DataProviderSettings
      .builder()
      .optionallyWith(postgreSqlSettings.map(value => value.buildAwsValue()))(
        _.postgreSqlSettings
      )
      .optionallyWith(mySqlSettings.map(value => value.buildAwsValue()))(
        _.mySqlSettings
      )
      .optionallyWith(oracleSettings.map(value => value.buildAwsValue()))(
        _.oracleSettings
      )
      .optionallyWith(
        microsoftSqlServerSettings.map(value => value.buildAwsValue())
      )(_.microsoftSqlServerSettings)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DataProviderSettings.ReadOnly =
    zio.aws.databasemigration.model.DataProviderSettings.wrap(buildAwsValue())
}
object DataProviderSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DataProviderSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.DataProviderSettings =
      zio.aws.databasemigration.model.DataProviderSettings(
        postgreSqlSettings.map(value => value.asEditable),
        mySqlSettings.map(value => value.asEditable),
        oracleSettings.map(value => value.asEditable),
        microsoftSqlServerSettings.map(value => value.asEditable)
      )
    def postgreSqlSettings: Optional[
      zio.aws.databasemigration.model.PostgreSqlDataProviderSettings.ReadOnly
    ]
    def mySqlSettings: Optional[
      zio.aws.databasemigration.model.MySqlDataProviderSettings.ReadOnly
    ]
    def oracleSettings: Optional[
      zio.aws.databasemigration.model.OracleDataProviderSettings.ReadOnly
    ]
    def microsoftSqlServerSettings: Optional[
      zio.aws.databasemigration.model.MicrosoftSqlServerDataProviderSettings.ReadOnly
    ]
    def getPostgreSqlSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.PostgreSqlDataProviderSettings.ReadOnly
    ] = AwsError.unwrapOptionField("postgreSqlSettings", postgreSqlSettings)
    def getMySqlSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.MySqlDataProviderSettings.ReadOnly
    ] = AwsError.unwrapOptionField("mySqlSettings", mySqlSettings)
    def getOracleSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.OracleDataProviderSettings.ReadOnly
    ] = AwsError.unwrapOptionField("oracleSettings", oracleSettings)
    def getMicrosoftSqlServerSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.MicrosoftSqlServerDataProviderSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "microsoftSqlServerSettings",
      microsoftSqlServerSettings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DataProviderSettings
  ) extends zio.aws.databasemigration.model.DataProviderSettings.ReadOnly {
    override val postgreSqlSettings: Optional[
      zio.aws.databasemigration.model.PostgreSqlDataProviderSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.postgreSqlSettings())
      .map(value =>
        zio.aws.databasemigration.model.PostgreSqlDataProviderSettings
          .wrap(value)
      )
    override val mySqlSettings: Optional[
      zio.aws.databasemigration.model.MySqlDataProviderSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.mySqlSettings())
      .map(value =>
        zio.aws.databasemigration.model.MySqlDataProviderSettings.wrap(value)
      )
    override val oracleSettings: Optional[
      zio.aws.databasemigration.model.OracleDataProviderSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.oracleSettings())
      .map(value =>
        zio.aws.databasemigration.model.OracleDataProviderSettings.wrap(value)
      )
    override val microsoftSqlServerSettings: Optional[
      zio.aws.databasemigration.model.MicrosoftSqlServerDataProviderSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.microsoftSqlServerSettings())
      .map(value =>
        zio.aws.databasemigration.model.MicrosoftSqlServerDataProviderSettings
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DataProviderSettings
  ): zio.aws.databasemigration.model.DataProviderSettings.ReadOnly =
    new Wrapper(impl)
}
