package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateReplicationConfigResponse(
    replicationConfig: Optional[
      zio.aws.databasemigration.model.ReplicationConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.CreateReplicationConfigResponse = {
    import CreateReplicationConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.CreateReplicationConfigResponse
      .builder()
      .optionallyWith(replicationConfig.map(value => value.buildAwsValue()))(
        _.replicationConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.CreateReplicationConfigResponse.ReadOnly =
    zio.aws.databasemigration.model.CreateReplicationConfigResponse
      .wrap(buildAwsValue())
}
object CreateReplicationConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.CreateReplicationConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.CreateReplicationConfigResponse =
      zio.aws.databasemigration.model.CreateReplicationConfigResponse(
        replicationConfig.map(value => value.asEditable)
      )
    def replicationConfig
        : Optional[zio.aws.databasemigration.model.ReplicationConfig.ReadOnly]
    def getReplicationConfig: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ReplicationConfig.ReadOnly
    ] = AwsError.unwrapOptionField("replicationConfig", replicationConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.CreateReplicationConfigResponse
  ) extends zio.aws.databasemigration.model.CreateReplicationConfigResponse.ReadOnly {
    override val replicationConfig
        : Optional[zio.aws.databasemigration.model.ReplicationConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationConfig())
        .map(value =>
          zio.aws.databasemigration.model.ReplicationConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.CreateReplicationConfigResponse
  ): zio.aws.databasemigration.model.CreateReplicationConfigResponse.ReadOnly =
    new Wrapper(impl)
}
