package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.TStamp
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Replication(
    replicationConfigIdentifier: Optional[String] = Optional.Absent,
    replicationConfigArn: Optional[String] = Optional.Absent,
    sourceEndpointArn: Optional[String] = Optional.Absent,
    targetEndpointArn: Optional[String] = Optional.Absent,
    replicationType: Optional[
      zio.aws.databasemigration.model.MigrationTypeValue
    ] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    provisionData: Optional[zio.aws.databasemigration.model.ProvisionData] =
      Optional.Absent,
    stopReason: Optional[String] = Optional.Absent,
    failureMessages: Optional[Iterable[String]] = Optional.Absent,
    replicationStats: Optional[
      zio.aws.databasemigration.model.ReplicationStats
    ] = Optional.Absent,
    startReplicationType: Optional[String] = Optional.Absent,
    cdcStartTime: Optional[TStamp] = Optional.Absent,
    cdcStartPosition: Optional[String] = Optional.Absent,
    cdcStopPosition: Optional[String] = Optional.Absent,
    recoveryCheckpoint: Optional[String] = Optional.Absent,
    replicationCreateTime: Optional[TStamp] = Optional.Absent,
    replicationUpdateTime: Optional[TStamp] = Optional.Absent,
    replicationLastStopTime: Optional[TStamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.Replication = {
    import Replication.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.Replication
      .builder()
      .optionallyWith(
        replicationConfigIdentifier.map(value => value: java.lang.String)
      )(_.replicationConfigIdentifier)
      .optionallyWith(
        replicationConfigArn.map(value => value: java.lang.String)
      )(_.replicationConfigArn)
      .optionallyWith(sourceEndpointArn.map(value => value: java.lang.String))(
        _.sourceEndpointArn
      )
      .optionallyWith(targetEndpointArn.map(value => value: java.lang.String))(
        _.targetEndpointArn
      )
      .optionallyWith(replicationType.map(value => value.unwrap))(
        _.replicationType
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(provisionData.map(value => value.buildAwsValue()))(
        _.provisionData
      )
      .optionallyWith(stopReason.map(value => value: java.lang.String))(
        _.stopReason
      )
      .optionallyWith(
        failureMessages.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.failureMessages)
      .optionallyWith(replicationStats.map(value => value.buildAwsValue()))(
        _.replicationStats
      )
      .optionallyWith(
        startReplicationType.map(value => value: java.lang.String)
      )(_.startReplicationType)
      .optionallyWith(cdcStartTime.map(value => TStamp.unwrap(value): Instant))(
        _.cdcStartTime
      )
      .optionallyWith(cdcStartPosition.map(value => value: java.lang.String))(
        _.cdcStartPosition
      )
      .optionallyWith(cdcStopPosition.map(value => value: java.lang.String))(
        _.cdcStopPosition
      )
      .optionallyWith(recoveryCheckpoint.map(value => value: java.lang.String))(
        _.recoveryCheckpoint
      )
      .optionallyWith(
        replicationCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.replicationCreateTime)
      .optionallyWith(
        replicationUpdateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.replicationUpdateTime)
      .optionallyWith(
        replicationLastStopTime.map(value => TStamp.unwrap(value): Instant)
      )(_.replicationLastStopTime)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.Replication.ReadOnly =
    zio.aws.databasemigration.model.Replication.wrap(buildAwsValue())
}
object Replication {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.Replication
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.Replication =
      zio.aws.databasemigration.model.Replication(
        replicationConfigIdentifier.map(value => value),
        replicationConfigArn.map(value => value),
        sourceEndpointArn.map(value => value),
        targetEndpointArn.map(value => value),
        replicationType.map(value => value),
        status.map(value => value),
        provisionData.map(value => value.asEditable),
        stopReason.map(value => value),
        failureMessages.map(value => value),
        replicationStats.map(value => value.asEditable),
        startReplicationType.map(value => value),
        cdcStartTime.map(value => value),
        cdcStartPosition.map(value => value),
        cdcStopPosition.map(value => value),
        recoveryCheckpoint.map(value => value),
        replicationCreateTime.map(value => value),
        replicationUpdateTime.map(value => value),
        replicationLastStopTime.map(value => value)
      )
    def replicationConfigIdentifier: Optional[String]
    def replicationConfigArn: Optional[String]
    def sourceEndpointArn: Optional[String]
    def targetEndpointArn: Optional[String]
    def replicationType
        : Optional[zio.aws.databasemigration.model.MigrationTypeValue]
    def status: Optional[String]
    def provisionData
        : Optional[zio.aws.databasemigration.model.ProvisionData.ReadOnly]
    def stopReason: Optional[String]
    def failureMessages: Optional[List[String]]
    def replicationStats
        : Optional[zio.aws.databasemigration.model.ReplicationStats.ReadOnly]
    def startReplicationType: Optional[String]
    def cdcStartTime: Optional[TStamp]
    def cdcStartPosition: Optional[String]
    def cdcStopPosition: Optional[String]
    def recoveryCheckpoint: Optional[String]
    def replicationCreateTime: Optional[TStamp]
    def replicationUpdateTime: Optional[TStamp]
    def replicationLastStopTime: Optional[TStamp]
    def getReplicationConfigIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "replicationConfigIdentifier",
        replicationConfigIdentifier
      )
    def getReplicationConfigArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replicationConfigArn", replicationConfigArn)
    def getSourceEndpointArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceEndpointArn", sourceEndpointArn)
    def getTargetEndpointArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetEndpointArn", targetEndpointArn)
    def getReplicationType: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.MigrationTypeValue
    ] = AwsError.unwrapOptionField("replicationType", replicationType)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getProvisionData: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ProvisionData.ReadOnly
    ] = AwsError.unwrapOptionField("provisionData", provisionData)
    def getStopReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stopReason", stopReason)
    def getFailureMessages: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("failureMessages", failureMessages)
    def getReplicationStats: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ReplicationStats.ReadOnly
    ] = AwsError.unwrapOptionField("replicationStats", replicationStats)
    def getStartReplicationType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("startReplicationType", startReplicationType)
    def getCdcStartTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("cdcStartTime", cdcStartTime)
    def getCdcStartPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cdcStartPosition", cdcStartPosition)
    def getCdcStopPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cdcStopPosition", cdcStopPosition)
    def getRecoveryCheckpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("recoveryCheckpoint", recoveryCheckpoint)
    def getReplicationCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("replicationCreateTime", replicationCreateTime)
    def getReplicationUpdateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("replicationUpdateTime", replicationUpdateTime)
    def getReplicationLastStopTime: ZIO[Any, AwsError, TStamp] = AwsError
      .unwrapOptionField("replicationLastStopTime", replicationLastStopTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.Replication
  ) extends zio.aws.databasemigration.model.Replication.ReadOnly {
    override val replicationConfigIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationConfigIdentifier())
        .map(value => value: String)
    override val replicationConfigArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationConfigArn())
      .map(value => value: String)
    override val sourceEndpointArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceEndpointArn())
      .map(value => value: String)
    override val targetEndpointArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.targetEndpointArn())
      .map(value => value: String)
    override val replicationType
        : Optional[zio.aws.databasemigration.model.MigrationTypeValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationType())
        .map(value =>
          zio.aws.databasemigration.model.MigrationTypeValue.wrap(value)
        )
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val provisionData
        : Optional[zio.aws.databasemigration.model.ProvisionData.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisionData())
        .map(value => zio.aws.databasemigration.model.ProvisionData.wrap(value))
    override val stopReason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.stopReason())
      .map(value => value: String)
    override val failureMessages: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.failureMessages())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val replicationStats
        : Optional[zio.aws.databasemigration.model.ReplicationStats.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationStats())
        .map(value =>
          zio.aws.databasemigration.model.ReplicationStats.wrap(value)
        )
    override val startReplicationType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.startReplicationType())
      .map(value => value: String)
    override val cdcStartTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.cdcStartTime())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val cdcStartPosition: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cdcStartPosition())
      .map(value => value: String)
    override val cdcStopPosition: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cdcStopPosition())
      .map(value => value: String)
    override val recoveryCheckpoint: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.recoveryCheckpoint())
      .map(value => value: String)
    override val replicationCreateTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationCreateTime())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val replicationUpdateTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationUpdateTime())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val replicationLastStopTime: Optional[TStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationLastStopTime())
        .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.Replication
  ): zio.aws.databasemigration.model.Replication.ReadOnly = new Wrapper(impl)
}
