package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyReplicationSubnetGroupRequest(
    replicationSubnetGroupIdentifier: String,
    replicationSubnetGroupDescription: Optional[String] = Optional.Absent,
    subnetIds: Iterable[String]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ModifyReplicationSubnetGroupRequest = {
    import ModifyReplicationSubnetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ModifyReplicationSubnetGroupRequest
      .builder()
      .replicationSubnetGroupIdentifier(
        replicationSubnetGroupIdentifier: java.lang.String
      )
      .optionallyWith(
        replicationSubnetGroupDescription.map(value => value: java.lang.String)
      )(_.replicationSubnetGroupDescription)
      .subnetIds(subnetIds.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ModifyReplicationSubnetGroupRequest.ReadOnly =
    zio.aws.databasemigration.model.ModifyReplicationSubnetGroupRequest
      .wrap(buildAwsValue())
}
object ModifyReplicationSubnetGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ModifyReplicationSubnetGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.ModifyReplicationSubnetGroupRequest =
      zio.aws.databasemigration.model.ModifyReplicationSubnetGroupRequest(
        replicationSubnetGroupIdentifier,
        replicationSubnetGroupDescription.map(value => value),
        subnetIds
      )
    def replicationSubnetGroupIdentifier: String
    def replicationSubnetGroupDescription: Optional[String]
    def subnetIds: List[String]
    def getReplicationSubnetGroupIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationSubnetGroupIdentifier)
    def getReplicationSubnetGroupDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "replicationSubnetGroupDescription",
        replicationSubnetGroupDescription
      )
    def getSubnetIds: ZIO[Any, Nothing, List[String]] = ZIO.succeed(subnetIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ModifyReplicationSubnetGroupRequest
  ) extends zio.aws.databasemigration.model.ModifyReplicationSubnetGroupRequest.ReadOnly {
    override val replicationSubnetGroupIdentifier: String =
      impl.replicationSubnetGroupIdentifier(): String
    override val replicationSubnetGroupDescription: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationSubnetGroupDescription())
        .map(value => value: String)
    override val subnetIds: List[String] = impl
      .subnetIds()
      .asScala
      .map { item =>
        item: String
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ModifyReplicationSubnetGroupRequest
  ): zio.aws.databasemigration.model.ModifyReplicationSubnetGroupRequest.ReadOnly =
    new Wrapper(impl)
}
