package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.TStamp
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class StartReplicationTaskRequest(
    replicationTaskArn: String,
    startReplicationTaskType: zio.aws.databasemigration.model.StartReplicationTaskTypeValue,
    cdcStartTime: Optional[TStamp] = Optional.Absent,
    cdcStartPosition: Optional[String] = Optional.Absent,
    cdcStopPosition: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskRequest = {
    import StartReplicationTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskRequest
      .builder()
      .replicationTaskArn(replicationTaskArn: java.lang.String)
      .startReplicationTaskType(startReplicationTaskType.unwrap)
      .optionallyWith(cdcStartTime.map(value => TStamp.unwrap(value): Instant))(
        _.cdcStartTime
      )
      .optionallyWith(cdcStartPosition.map(value => value: java.lang.String))(
        _.cdcStartPosition
      )
      .optionallyWith(cdcStopPosition.map(value => value: java.lang.String))(
        _.cdcStopPosition
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.StartReplicationTaskRequest.ReadOnly =
    zio.aws.databasemigration.model.StartReplicationTaskRequest
      .wrap(buildAwsValue())
}
object StartReplicationTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.StartReplicationTaskRequest =
      zio.aws.databasemigration.model.StartReplicationTaskRequest(
        replicationTaskArn,
        startReplicationTaskType,
        cdcStartTime.map(value => value),
        cdcStartPosition.map(value => value),
        cdcStopPosition.map(value => value)
      )
    def replicationTaskArn: String
    def startReplicationTaskType
        : zio.aws.databasemigration.model.StartReplicationTaskTypeValue
    def cdcStartTime: Optional[TStamp]
    def cdcStartPosition: Optional[String]
    def cdcStopPosition: Optional[String]
    def getReplicationTaskArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationTaskArn)
    def getStartReplicationTaskType: ZIO[
      Any,
      Nothing,
      zio.aws.databasemigration.model.StartReplicationTaskTypeValue
    ] = ZIO.succeed(startReplicationTaskType)
    def getCdcStartTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("cdcStartTime", cdcStartTime)
    def getCdcStartPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cdcStartPosition", cdcStartPosition)
    def getCdcStopPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cdcStopPosition", cdcStopPosition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskRequest
  ) extends zio.aws.databasemigration.model.StartReplicationTaskRequest.ReadOnly {
    override val replicationTaskArn: String = impl.replicationTaskArn(): String
    override val startReplicationTaskType
        : zio.aws.databasemigration.model.StartReplicationTaskTypeValue =
      zio.aws.databasemigration.model.StartReplicationTaskTypeValue
        .wrap(impl.startReplicationTaskType())
    override val cdcStartTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.cdcStartTime())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val cdcStartPosition: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cdcStartPosition())
      .map(value => value: String)
    override val cdcStopPosition: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cdcStopPosition())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskRequest
  ): zio.aws.databasemigration.model.StartReplicationTaskRequest.ReadOnly =
    new Wrapper(impl)
}
