package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.TStamp
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Event(
    sourceIdentifier: Optional[String] = Optional.Absent,
    sourceType: Optional[zio.aws.databasemigration.model.SourceType] =
      Optional.Absent,
    message: Optional[String] = Optional.Absent,
    eventCategories: Optional[Iterable[String]] = Optional.Absent,
    date: Optional[TStamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.Event = {
    import Event.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.Event
      .builder()
      .optionallyWith(sourceIdentifier.map(value => value: java.lang.String))(
        _.sourceIdentifier
      )
      .optionallyWith(sourceType.map(value => value.unwrap))(_.sourceType)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(
        eventCategories.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.eventCategories)
      .optionallyWith(date.map(value => TStamp.unwrap(value): Instant))(_.date)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.Event.ReadOnly =
    zio.aws.databasemigration.model.Event.wrap(buildAwsValue())
}
object Event {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.Event
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.Event =
      zio.aws.databasemigration.model.Event(
        sourceIdentifier.map(value => value),
        sourceType.map(value => value),
        message.map(value => value),
        eventCategories.map(value => value),
        date.map(value => value)
      )
    def sourceIdentifier: Optional[String]
    def sourceType: Optional[zio.aws.databasemigration.model.SourceType]
    def message: Optional[String]
    def eventCategories: Optional[List[String]]
    def date: Optional[TStamp]
    def getSourceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceIdentifier", sourceIdentifier)
    def getSourceType
        : ZIO[Any, AwsError, zio.aws.databasemigration.model.SourceType] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
    def getEventCategories: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("eventCategories", eventCategories)
    def getDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("date", date)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.Event
  ) extends zio.aws.databasemigration.model.Event.ReadOnly {
    override val sourceIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceIdentifier())
      .map(value => value: String)
    override val sourceType
        : Optional[zio.aws.databasemigration.model.SourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceType())
        .map(value => zio.aws.databasemigration.model.SourceType.wrap(value))
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
    override val eventCategories: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.eventCategories())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val date: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.date())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.Event
  ): zio.aws.databasemigration.model.Event.ReadOnly = new Wrapper(impl)
}
