package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DmsTransferSettings(
    serviceAccessRoleArn: Optional[String] = Optional.Absent,
    bucketName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DmsTransferSettings = {
    import DmsTransferSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DmsTransferSettings
      .builder()
      .optionallyWith(
        serviceAccessRoleArn.map(value => value: java.lang.String)
      )(_.serviceAccessRoleArn)
      .optionallyWith(bucketName.map(value => value: java.lang.String))(
        _.bucketName
      )
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.DmsTransferSettings.ReadOnly =
    zio.aws.databasemigration.model.DmsTransferSettings.wrap(buildAwsValue())
}
object DmsTransferSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DmsTransferSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.DmsTransferSettings =
      zio.aws.databasemigration.model.DmsTransferSettings(
        serviceAccessRoleArn.map(value => value),
        bucketName.map(value => value)
      )
    def serviceAccessRoleArn: Optional[String]
    def bucketName: Optional[String]
    def getServiceAccessRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceAccessRoleArn", serviceAccessRoleArn)
    def getBucketName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bucketName", bucketName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DmsTransferSettings
  ) extends zio.aws.databasemigration.model.DmsTransferSettings.ReadOnly {
    override val serviceAccessRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceAccessRoleArn())
      .map(value => value: String)
    override val bucketName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DmsTransferSettings
  ): zio.aws.databasemigration.model.DmsTransferSettings.ReadOnly = new Wrapper(
    impl
  )
}
