package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.{
  IntegerOptional,
  BooleanOptional
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class EndpointSetting(
    name: Optional[String] = Optional.Absent,
    `type`: Optional[zio.aws.databasemigration.model.EndpointSettingTypeValue] =
      Optional.Absent,
    enumValues: Optional[Iterable[String]] = Optional.Absent,
    sensitive: Optional[BooleanOptional] = Optional.Absent,
    units: Optional[String] = Optional.Absent,
    applicability: Optional[String] = Optional.Absent,
    intValueMin: Optional[IntegerOptional] = Optional.Absent,
    intValueMax: Optional[IntegerOptional] = Optional.Absent,
    defaultValue: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.EndpointSetting = {
    import EndpointSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.EndpointSetting
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        enumValues.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.enumValues)
      .optionallyWith(sensitive.map(value => value: java.lang.Boolean))(
        _.sensitive
      )
      .optionallyWith(units.map(value => value: java.lang.String))(_.units)
      .optionallyWith(applicability.map(value => value: java.lang.String))(
        _.applicability
      )
      .optionallyWith(intValueMin.map(value => value: Integer))(_.intValueMin)
      .optionallyWith(intValueMax.map(value => value: Integer))(_.intValueMax)
      .optionallyWith(defaultValue.map(value => value: java.lang.String))(
        _.defaultValue
      )
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.EndpointSetting.ReadOnly =
    zio.aws.databasemigration.model.EndpointSetting.wrap(buildAwsValue())
}
object EndpointSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.EndpointSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.EndpointSetting =
      zio.aws.databasemigration.model.EndpointSetting(
        name.map(value => value),
        `type`.map(value => value),
        enumValues.map(value => value),
        sensitive.map(value => value),
        units.map(value => value),
        applicability.map(value => value),
        intValueMin.map(value => value),
        intValueMax.map(value => value),
        defaultValue.map(value => value)
      )
    def name: Optional[String]
    def `type`
        : Optional[zio.aws.databasemigration.model.EndpointSettingTypeValue]
    def enumValues: Optional[List[String]]
    def sensitive: Optional[BooleanOptional]
    def units: Optional[String]
    def applicability: Optional[String]
    def intValueMin: Optional[IntegerOptional]
    def intValueMax: Optional[IntegerOptional]
    def defaultValue: Optional[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.EndpointSettingTypeValue
    ] = AwsError.unwrapOptionField("type", `type`)
    def getEnumValues: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("enumValues", enumValues)
    def getSensitive: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("sensitive", sensitive)
    def getUnits: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("units", units)
    def getApplicability: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("applicability", applicability)
    def getIntValueMin: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("intValueMin", intValueMin)
    def getIntValueMax: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("intValueMax", intValueMax)
    def getDefaultValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("defaultValue", defaultValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.EndpointSetting
  ) extends zio.aws.databasemigration.model.EndpointSetting.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val `type`
        : Optional[zio.aws.databasemigration.model.EndpointSettingTypeValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.databasemigration.model.EndpointSettingTypeValue.wrap(value)
        )
    override val enumValues: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.enumValues())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val sensitive: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.sensitive())
      .map(value => value: BooleanOptional)
    override val units: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.units())
      .map(value => value: String)
    override val applicability: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.applicability())
      .map(value => value: String)
    override val intValueMin: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.intValueMin())
      .map(value => value: IntegerOptional)
    override val intValueMax: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.intValueMax())
      .map(value => value: IntegerOptional)
    override val defaultValue: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultValue())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.EndpointSetting
  ): zio.aws.databasemigration.model.EndpointSetting.ReadOnly = new Wrapper(
    impl
  )
}
