package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteCertificateRequest(certificateArn: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DeleteCertificateRequest = {
    import DeleteCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DeleteCertificateRequest
      .builder()
      .certificateArn(certificateArn: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DeleteCertificateRequest.ReadOnly =
    zio.aws.databasemigration.model.DeleteCertificateRequest
      .wrap(buildAwsValue())
}
object DeleteCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DeleteCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.DeleteCertificateRequest =
      zio.aws.databasemigration.model.DeleteCertificateRequest(certificateArn)
    def certificateArn: String
    def getCertificateArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(certificateArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DeleteCertificateRequest
  ) extends zio.aws.databasemigration.model.DeleteCertificateRequest.ReadOnly {
    override val certificateArn: String = impl.certificateArn(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DeleteCertificateRequest
  ): zio.aws.databasemigration.model.DeleteCertificateRequest.ReadOnly =
    new Wrapper(impl)
}
