package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeReplicationSubnetGroupsResponse(
    marker: Optional[String] = Optional.Absent,
    replicationSubnetGroups: Optional[
      Iterable[zio.aws.databasemigration.model.ReplicationSubnetGroup]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsResponse = {
    import DescribeReplicationSubnetGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        replicationSubnetGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicationSubnetGroups)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeReplicationSubnetGroupsResponse.ReadOnly =
    zio.aws.databasemigration.model.DescribeReplicationSubnetGroupsResponse
      .wrap(buildAwsValue())
}
object DescribeReplicationSubnetGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeReplicationSubnetGroupsResponse =
      zio.aws.databasemigration.model.DescribeReplicationSubnetGroupsResponse(
        marker.map(value => value),
        replicationSubnetGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def replicationSubnetGroups: Optional[
      List[zio.aws.databasemigration.model.ReplicationSubnetGroup.ReadOnly]
    ]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getReplicationSubnetGroups: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.ReplicationSubnetGroup.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "replicationSubnetGroups",
      replicationSubnetGroups
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsResponse
  ) extends zio.aws.databasemigration.model.DescribeReplicationSubnetGroupsResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val replicationSubnetGroups: Optional[
      List[zio.aws.databasemigration.model.ReplicationSubnetGroup.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationSubnetGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.ReplicationSubnetGroup.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsResponse
  ): zio.aws.databasemigration.model.DescribeReplicationSubnetGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
