package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeFleetAdvisorSchemaObjectSummaryResponse(
    fleetAdvisorSchemaObjects: Optional[
      Iterable[zio.aws.databasemigration.model.FleetAdvisorSchemaObjectResponse]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryResponse = {
    import DescribeFleetAdvisorSchemaObjectSummaryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryResponse
      .builder()
      .optionallyWith(
        fleetAdvisorSchemaObjects.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fleetAdvisorSchemaObjects)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryResponse.ReadOnly =
    zio.aws.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryResponse
      .wrap(buildAwsValue())
}
object DescribeFleetAdvisorSchemaObjectSummaryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryResponse =
      zio.aws.databasemigration.model
        .DescribeFleetAdvisorSchemaObjectSummaryResponse(
          fleetAdvisorSchemaObjects.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          nextToken.map(value => value)
        )
    def fleetAdvisorSchemaObjects: Optional[List[
      zio.aws.databasemigration.model.FleetAdvisorSchemaObjectResponse.ReadOnly
    ]]
    def nextToken: Optional[String]
    def getFleetAdvisorSchemaObjects: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.FleetAdvisorSchemaObjectResponse.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "fleetAdvisorSchemaObjects",
      fleetAdvisorSchemaObjects
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryResponse
  ) extends zio.aws.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryResponse.ReadOnly {
    override val fleetAdvisorSchemaObjects: Optional[List[
      zio.aws.databasemigration.model.FleetAdvisorSchemaObjectResponse.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetAdvisorSchemaObjects())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.FleetAdvisorSchemaObjectResponse
            .wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryResponse
  ): zio.aws.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryResponse.ReadOnly =
    new Wrapper(impl)
}
