package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateFleetAdvisorCollectorResponse(
    collectorReferencedId: Optional[String] = Optional.Absent,
    collectorName: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    serviceAccessRoleArn: Optional[String] = Optional.Absent,
    s3BucketName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.CreateFleetAdvisorCollectorResponse = {
    import CreateFleetAdvisorCollectorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.CreateFleetAdvisorCollectorResponse
      .builder()
      .optionallyWith(
        collectorReferencedId.map(value => value: java.lang.String)
      )(_.collectorReferencedId)
      .optionallyWith(collectorName.map(value => value: java.lang.String))(
        _.collectorName
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        serviceAccessRoleArn.map(value => value: java.lang.String)
      )(_.serviceAccessRoleArn)
      .optionallyWith(s3BucketName.map(value => value: java.lang.String))(
        _.s3BucketName
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.CreateFleetAdvisorCollectorResponse.ReadOnly =
    zio.aws.databasemigration.model.CreateFleetAdvisorCollectorResponse
      .wrap(buildAwsValue())
}
object CreateFleetAdvisorCollectorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.CreateFleetAdvisorCollectorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.CreateFleetAdvisorCollectorResponse =
      zio.aws.databasemigration.model.CreateFleetAdvisorCollectorResponse(
        collectorReferencedId.map(value => value),
        collectorName.map(value => value),
        description.map(value => value),
        serviceAccessRoleArn.map(value => value),
        s3BucketName.map(value => value)
      )
    def collectorReferencedId: Optional[String]
    def collectorName: Optional[String]
    def description: Optional[String]
    def serviceAccessRoleArn: Optional[String]
    def s3BucketName: Optional[String]
    def getCollectorReferencedId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("collectorReferencedId", collectorReferencedId)
    def getCollectorName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("collectorName", collectorName)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getServiceAccessRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceAccessRoleArn", serviceAccessRoleArn)
    def getS3BucketName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3BucketName", s3BucketName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.CreateFleetAdvisorCollectorResponse
  ) extends zio.aws.databasemigration.model.CreateFleetAdvisorCollectorResponse.ReadOnly {
    override val collectorReferencedId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.collectorReferencedId())
      .map(value => value: String)
    override val collectorName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.collectorName())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val serviceAccessRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceAccessRoleArn())
      .map(value => value: String)
    override val s3BucketName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.s3BucketName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.CreateFleetAdvisorCollectorResponse
  ): zio.aws.databasemigration.model.CreateFleetAdvisorCollectorResponse.ReadOnly =
    new Wrapper(impl)
}
