package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.{
  SecretString,
  IntegerOptional,
  BooleanOptional
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class KafkaSettings(
    broker: Optional[String] = Optional.Absent,
    topic: Optional[String] = Optional.Absent,
    messageFormat: Optional[
      zio.aws.databasemigration.model.MessageFormatValue
    ] = Optional.Absent,
    includeTransactionDetails: Optional[BooleanOptional] = Optional.Absent,
    includePartitionValue: Optional[BooleanOptional] = Optional.Absent,
    partitionIncludeSchemaTable: Optional[BooleanOptional] = Optional.Absent,
    includeTableAlterOperations: Optional[BooleanOptional] = Optional.Absent,
    includeControlDetails: Optional[BooleanOptional] = Optional.Absent,
    messageMaxBytes: Optional[IntegerOptional] = Optional.Absent,
    includeNullAndEmpty: Optional[BooleanOptional] = Optional.Absent,
    securityProtocol: Optional[
      zio.aws.databasemigration.model.KafkaSecurityProtocol
    ] = Optional.Absent,
    sslClientCertificateArn: Optional[String] = Optional.Absent,
    sslClientKeyArn: Optional[String] = Optional.Absent,
    sslClientKeyPassword: Optional[SecretString] = Optional.Absent,
    sslCaCertificateArn: Optional[String] = Optional.Absent,
    saslUsername: Optional[String] = Optional.Absent,
    saslPassword: Optional[SecretString] = Optional.Absent,
    noHexPrefix: Optional[BooleanOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.KafkaSettings = {
    import KafkaSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.KafkaSettings
      .builder()
      .optionallyWith(broker.map(value => value: java.lang.String))(_.broker)
      .optionallyWith(topic.map(value => value: java.lang.String))(_.topic)
      .optionallyWith(messageFormat.map(value => value.unwrap))(_.messageFormat)
      .optionallyWith(
        includeTransactionDetails.map(value => value: java.lang.Boolean)
      )(_.includeTransactionDetails)
      .optionallyWith(
        includePartitionValue.map(value => value: java.lang.Boolean)
      )(_.includePartitionValue)
      .optionallyWith(
        partitionIncludeSchemaTable.map(value => value: java.lang.Boolean)
      )(_.partitionIncludeSchemaTable)
      .optionallyWith(
        includeTableAlterOperations.map(value => value: java.lang.Boolean)
      )(_.includeTableAlterOperations)
      .optionallyWith(
        includeControlDetails.map(value => value: java.lang.Boolean)
      )(_.includeControlDetails)
      .optionallyWith(messageMaxBytes.map(value => value: Integer))(
        _.messageMaxBytes
      )
      .optionallyWith(
        includeNullAndEmpty.map(value => value: java.lang.Boolean)
      )(_.includeNullAndEmpty)
      .optionallyWith(securityProtocol.map(value => value.unwrap))(
        _.securityProtocol
      )
      .optionallyWith(
        sslClientCertificateArn.map(value => value: java.lang.String)
      )(_.sslClientCertificateArn)
      .optionallyWith(sslClientKeyArn.map(value => value: java.lang.String))(
        _.sslClientKeyArn
      )
      .optionallyWith(
        sslClientKeyPassword.map(value =>
          SecretString.unwrap(value): java.lang.String
        )
      )(_.sslClientKeyPassword)
      .optionallyWith(
        sslCaCertificateArn.map(value => value: java.lang.String)
      )(_.sslCaCertificateArn)
      .optionallyWith(saslUsername.map(value => value: java.lang.String))(
        _.saslUsername
      )
      .optionallyWith(
        saslPassword.map(value => SecretString.unwrap(value): java.lang.String)
      )(_.saslPassword)
      .optionallyWith(noHexPrefix.map(value => value: java.lang.Boolean))(
        _.noHexPrefix
      )
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.KafkaSettings.ReadOnly =
    zio.aws.databasemigration.model.KafkaSettings.wrap(buildAwsValue())
}
object KafkaSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.KafkaSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.KafkaSettings =
      zio.aws.databasemigration.model.KafkaSettings(
        broker.map(value => value),
        topic.map(value => value),
        messageFormat.map(value => value),
        includeTransactionDetails.map(value => value),
        includePartitionValue.map(value => value),
        partitionIncludeSchemaTable.map(value => value),
        includeTableAlterOperations.map(value => value),
        includeControlDetails.map(value => value),
        messageMaxBytes.map(value => value),
        includeNullAndEmpty.map(value => value),
        securityProtocol.map(value => value),
        sslClientCertificateArn.map(value => value),
        sslClientKeyArn.map(value => value),
        sslClientKeyPassword.map(value => value),
        sslCaCertificateArn.map(value => value),
        saslUsername.map(value => value),
        saslPassword.map(value => value),
        noHexPrefix.map(value => value)
      )
    def broker: Optional[String]
    def topic: Optional[String]
    def messageFormat
        : Optional[zio.aws.databasemigration.model.MessageFormatValue]
    def includeTransactionDetails: Optional[BooleanOptional]
    def includePartitionValue: Optional[BooleanOptional]
    def partitionIncludeSchemaTable: Optional[BooleanOptional]
    def includeTableAlterOperations: Optional[BooleanOptional]
    def includeControlDetails: Optional[BooleanOptional]
    def messageMaxBytes: Optional[IntegerOptional]
    def includeNullAndEmpty: Optional[BooleanOptional]
    def securityProtocol
        : Optional[zio.aws.databasemigration.model.KafkaSecurityProtocol]
    def sslClientCertificateArn: Optional[String]
    def sslClientKeyArn: Optional[String]
    def sslClientKeyPassword: Optional[SecretString]
    def sslCaCertificateArn: Optional[String]
    def saslUsername: Optional[String]
    def saslPassword: Optional[SecretString]
    def noHexPrefix: Optional[BooleanOptional]
    def getBroker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("broker", broker)
    def getTopic: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("topic", topic)
    def getMessageFormat: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.MessageFormatValue
    ] = AwsError.unwrapOptionField("messageFormat", messageFormat)
    def getIncludeTransactionDetails: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "includeTransactionDetails",
        includeTransactionDetails
      )
    def getIncludePartitionValue: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("includePartitionValue", includePartitionValue)
    def getPartitionIncludeSchemaTable: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "partitionIncludeSchemaTable",
        partitionIncludeSchemaTable
      )
    def getIncludeTableAlterOperations: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "includeTableAlterOperations",
        includeTableAlterOperations
      )
    def getIncludeControlDetails: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("includeControlDetails", includeControlDetails)
    def getMessageMaxBytes: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("messageMaxBytes", messageMaxBytes)
    def getIncludeNullAndEmpty: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("includeNullAndEmpty", includeNullAndEmpty)
    def getSecurityProtocol: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.KafkaSecurityProtocol
    ] = AwsError.unwrapOptionField("securityProtocol", securityProtocol)
    def getSslClientCertificateArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("sslClientCertificateArn", sslClientCertificateArn)
    def getSslClientKeyArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sslClientKeyArn", sslClientKeyArn)
    def getSslClientKeyPassword: ZIO[Any, AwsError, SecretString] =
      AwsError.unwrapOptionField("sslClientKeyPassword", sslClientKeyPassword)
    def getSslCaCertificateArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sslCaCertificateArn", sslCaCertificateArn)
    def getSaslUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("saslUsername", saslUsername)
    def getSaslPassword: ZIO[Any, AwsError, SecretString] =
      AwsError.unwrapOptionField("saslPassword", saslPassword)
    def getNoHexPrefix: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("noHexPrefix", noHexPrefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.KafkaSettings
  ) extends zio.aws.databasemigration.model.KafkaSettings.ReadOnly {
    override val broker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.broker())
      .map(value => value: String)
    override val topic: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.topic())
      .map(value => value: String)
    override val messageFormat
        : Optional[zio.aws.databasemigration.model.MessageFormatValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.messageFormat())
        .map(value =>
          zio.aws.databasemigration.model.MessageFormatValue.wrap(value)
        )
    override val includeTransactionDetails: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeTransactionDetails())
        .map(value => value: BooleanOptional)
    override val includePartitionValue: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includePartitionValue())
        .map(value => value: BooleanOptional)
    override val partitionIncludeSchemaTable: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.partitionIncludeSchemaTable())
        .map(value => value: BooleanOptional)
    override val includeTableAlterOperations: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeTableAlterOperations())
        .map(value => value: BooleanOptional)
    override val includeControlDetails: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeControlDetails())
        .map(value => value: BooleanOptional)
    override val messageMaxBytes: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.messageMaxBytes())
        .map(value => value: IntegerOptional)
    override val includeNullAndEmpty: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeNullAndEmpty())
        .map(value => value: BooleanOptional)
    override val securityProtocol
        : Optional[zio.aws.databasemigration.model.KafkaSecurityProtocol] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityProtocol())
        .map(value =>
          zio.aws.databasemigration.model.KafkaSecurityProtocol.wrap(value)
        )
    override val sslClientCertificateArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sslClientCertificateArn())
        .map(value => value: String)
    override val sslClientKeyArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sslClientKeyArn())
      .map(value => value: String)
    override val sslClientKeyPassword: Optional[SecretString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sslClientKeyPassword())
        .map(value =>
          zio.aws.databasemigration.model.primitives.SecretString(value)
        )
    override val sslCaCertificateArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sslCaCertificateArn())
      .map(value => value: String)
    override val saslUsername: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.saslUsername())
      .map(value => value: String)
    override val saslPassword: Optional[SecretString] = zio.aws.core.internal
      .optionalFromNullable(impl.saslPassword())
      .map(value =>
        zio.aws.databasemigration.model.primitives.SecretString(value)
      )
    override val noHexPrefix: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.noHexPrefix())
      .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.KafkaSettings
  ): zio.aws.databasemigration.model.KafkaSettings.ReadOnly = new Wrapper(impl)
}
