package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.{
  BooleanOptional,
  IntegerOptional
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ElasticsearchSettings(
    serviceAccessRoleArn: String,
    endpointUri: String,
    fullLoadErrorPercentage: Optional[IntegerOptional] = Optional.Absent,
    errorRetryDuration: Optional[IntegerOptional] = Optional.Absent,
    useNewMappingType: Optional[BooleanOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ElasticsearchSettings = {
    import ElasticsearchSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ElasticsearchSettings
      .builder()
      .serviceAccessRoleArn(serviceAccessRoleArn: java.lang.String)
      .endpointUri(endpointUri: java.lang.String)
      .optionallyWith(fullLoadErrorPercentage.map(value => value: Integer))(
        _.fullLoadErrorPercentage
      )
      .optionallyWith(errorRetryDuration.map(value => value: Integer))(
        _.errorRetryDuration
      )
      .optionallyWith(useNewMappingType.map(value => value: java.lang.Boolean))(
        _.useNewMappingType
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ElasticsearchSettings.ReadOnly =
    zio.aws.databasemigration.model.ElasticsearchSettings.wrap(buildAwsValue())
}
object ElasticsearchSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ElasticsearchSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.ElasticsearchSettings =
      zio.aws.databasemigration.model.ElasticsearchSettings(
        serviceAccessRoleArn,
        endpointUri,
        fullLoadErrorPercentage.map(value => value),
        errorRetryDuration.map(value => value),
        useNewMappingType.map(value => value)
      )
    def serviceAccessRoleArn: String
    def endpointUri: String
    def fullLoadErrorPercentage: Optional[IntegerOptional]
    def errorRetryDuration: Optional[IntegerOptional]
    def useNewMappingType: Optional[BooleanOptional]
    def getServiceAccessRoleArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(serviceAccessRoleArn)
    def getEndpointUri: ZIO[Any, Nothing, String] = ZIO.succeed(endpointUri)
    def getFullLoadErrorPercentage: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "fullLoadErrorPercentage",
        fullLoadErrorPercentage
      )
    def getErrorRetryDuration: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("errorRetryDuration", errorRetryDuration)
    def getUseNewMappingType: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("useNewMappingType", useNewMappingType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ElasticsearchSettings
  ) extends zio.aws.databasemigration.model.ElasticsearchSettings.ReadOnly {
    override val serviceAccessRoleArn: String =
      impl.serviceAccessRoleArn(): String
    override val endpointUri: String = impl.endpointUri(): String
    override val fullLoadErrorPercentage: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fullLoadErrorPercentage())
        .map(value => value: IntegerOptional)
    override val errorRetryDuration: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorRetryDuration())
        .map(value => value: IntegerOptional)
    override val useNewMappingType: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.useNewMappingType())
        .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ElasticsearchSettings
  ): zio.aws.databasemigration.model.ElasticsearchSettings.ReadOnly =
    new Wrapper(impl)
}
