package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteFleetAdvisorDatabasesResponse(
    databaseIds: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DeleteFleetAdvisorDatabasesResponse = {
    import DeleteFleetAdvisorDatabasesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DeleteFleetAdvisorDatabasesResponse
      .builder()
      .optionallyWith(
        databaseIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.databaseIds)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DeleteFleetAdvisorDatabasesResponse.ReadOnly =
    zio.aws.databasemigration.model.DeleteFleetAdvisorDatabasesResponse
      .wrap(buildAwsValue())
}
object DeleteFleetAdvisorDatabasesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DeleteFleetAdvisorDatabasesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DeleteFleetAdvisorDatabasesResponse =
      zio.aws.databasemigration.model
        .DeleteFleetAdvisorDatabasesResponse(databaseIds.map(value => value))
    def databaseIds: Optional[List[String]]
    def getDatabaseIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("databaseIds", databaseIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DeleteFleetAdvisorDatabasesResponse
  ) extends zio.aws.databasemigration.model.DeleteFleetAdvisorDatabasesResponse.ReadOnly {
    override val databaseIds: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DeleteFleetAdvisorDatabasesResponse
  ): zio.aws.databasemigration.model.DeleteFleetAdvisorDatabasesResponse.ReadOnly =
    new Wrapper(impl)
}
