package zio.aws.databasemigration.model
import scala.jdk.CollectionConverters._
sealed trait DatePartitionSequenceValue {
  def unwrap: software.amazon.awssdk.services.databasemigration.model.DatePartitionSequenceValue
}
object DatePartitionSequenceValue {
  def wrap(
      value: software.amazon.awssdk.services.databasemigration.model.DatePartitionSequenceValue
  ): zio.aws.databasemigration.model.DatePartitionSequenceValue = value match {
    case software.amazon.awssdk.services.databasemigration.model.DatePartitionSequenceValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databasemigration.model.DatePartitionSequenceValue.YYYYMMDD =>
      val r = YYYYMMDD
      r
    case software.amazon.awssdk.services.databasemigration.model.DatePartitionSequenceValue.YYYYMMDDHH =>
      val r = YYYYMMDDHH
      r
    case software.amazon.awssdk.services.databasemigration.model.DatePartitionSequenceValue.YYYYMM =>
      val r = YYYYMM
      r
    case software.amazon.awssdk.services.databasemigration.model.DatePartitionSequenceValue.MMYYYYDD =>
      val r = MMYYYYDD
      r
    case software.amazon.awssdk.services.databasemigration.model.DatePartitionSequenceValue.DDMMYYYY =>
      val r = DDMMYYYY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.databasemigration.model.DatePartitionSequenceValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.DatePartitionSequenceValue =
      software.amazon.awssdk.services.databasemigration.model.DatePartitionSequenceValue.UNKNOWN_TO_SDK_VERSION
  }
  case object YYYYMMDD
      extends zio.aws.databasemigration.model.DatePartitionSequenceValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.DatePartitionSequenceValue =
      software.amazon.awssdk.services.databasemigration.model.DatePartitionSequenceValue.YYYYMMDD
  }
  case object YYYYMMDDHH
      extends zio.aws.databasemigration.model.DatePartitionSequenceValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.DatePartitionSequenceValue =
      software.amazon.awssdk.services.databasemigration.model.DatePartitionSequenceValue.YYYYMMDDHH
  }
  case object YYYYMM
      extends zio.aws.databasemigration.model.DatePartitionSequenceValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.DatePartitionSequenceValue =
      software.amazon.awssdk.services.databasemigration.model.DatePartitionSequenceValue.YYYYMM
  }
  case object MMYYYYDD
      extends zio.aws.databasemigration.model.DatePartitionSequenceValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.DatePartitionSequenceValue =
      software.amazon.awssdk.services.databasemigration.model.DatePartitionSequenceValue.MMYYYYDD
  }
  case object DDMMYYYY
      extends zio.aws.databasemigration.model.DatePartitionSequenceValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.DatePartitionSequenceValue =
      software.amazon.awssdk.services.databasemigration.model.DatePartitionSequenceValue.DDMMYYYY
  }
}
