package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CollectorResponse(
    collectorReferencedId: Optional[String] = Optional.Absent,
    collectorName: Optional[String] = Optional.Absent,
    collectorVersion: Optional[String] = Optional.Absent,
    versionStatus: Optional[zio.aws.databasemigration.model.VersionStatus] =
      Optional.Absent,
    description: Optional[String] = Optional.Absent,
    s3BucketName: Optional[String] = Optional.Absent,
    serviceAccessRoleArn: Optional[String] = Optional.Absent,
    collectorHealthCheck: Optional[
      zio.aws.databasemigration.model.CollectorHealthCheck
    ] = Optional.Absent,
    lastDataReceived: Optional[String] = Optional.Absent,
    registeredDate: Optional[String] = Optional.Absent,
    createdDate: Optional[String] = Optional.Absent,
    modifiedDate: Optional[String] = Optional.Absent,
    inventoryData: Optional[zio.aws.databasemigration.model.InventoryData] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.CollectorResponse = {
    import CollectorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.CollectorResponse
      .builder()
      .optionallyWith(
        collectorReferencedId.map(value => value: java.lang.String)
      )(_.collectorReferencedId)
      .optionallyWith(collectorName.map(value => value: java.lang.String))(
        _.collectorName
      )
      .optionallyWith(collectorVersion.map(value => value: java.lang.String))(
        _.collectorVersion
      )
      .optionallyWith(versionStatus.map(value => value.unwrap))(_.versionStatus)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(s3BucketName.map(value => value: java.lang.String))(
        _.s3BucketName
      )
      .optionallyWith(
        serviceAccessRoleArn.map(value => value: java.lang.String)
      )(_.serviceAccessRoleArn)
      .optionallyWith(collectorHealthCheck.map(value => value.buildAwsValue()))(
        _.collectorHealthCheck
      )
      .optionallyWith(lastDataReceived.map(value => value: java.lang.String))(
        _.lastDataReceived
      )
      .optionallyWith(registeredDate.map(value => value: java.lang.String))(
        _.registeredDate
      )
      .optionallyWith(createdDate.map(value => value: java.lang.String))(
        _.createdDate
      )
      .optionallyWith(modifiedDate.map(value => value: java.lang.String))(
        _.modifiedDate
      )
      .optionallyWith(inventoryData.map(value => value.buildAwsValue()))(
        _.inventoryData
      )
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.CollectorResponse.ReadOnly =
    zio.aws.databasemigration.model.CollectorResponse.wrap(buildAwsValue())
}
object CollectorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.CollectorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.CollectorResponse =
      zio.aws.databasemigration.model.CollectorResponse(
        collectorReferencedId.map(value => value),
        collectorName.map(value => value),
        collectorVersion.map(value => value),
        versionStatus.map(value => value),
        description.map(value => value),
        s3BucketName.map(value => value),
        serviceAccessRoleArn.map(value => value),
        collectorHealthCheck.map(value => value.asEditable),
        lastDataReceived.map(value => value),
        registeredDate.map(value => value),
        createdDate.map(value => value),
        modifiedDate.map(value => value),
        inventoryData.map(value => value.asEditable)
      )
    def collectorReferencedId: Optional[String]
    def collectorName: Optional[String]
    def collectorVersion: Optional[String]
    def versionStatus: Optional[zio.aws.databasemigration.model.VersionStatus]
    def description: Optional[String]
    def s3BucketName: Optional[String]
    def serviceAccessRoleArn: Optional[String]
    def collectorHealthCheck: Optional[
      zio.aws.databasemigration.model.CollectorHealthCheck.ReadOnly
    ]
    def lastDataReceived: Optional[String]
    def registeredDate: Optional[String]
    def createdDate: Optional[String]
    def modifiedDate: Optional[String]
    def inventoryData
        : Optional[zio.aws.databasemigration.model.InventoryData.ReadOnly]
    def getCollectorReferencedId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("collectorReferencedId", collectorReferencedId)
    def getCollectorName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("collectorName", collectorName)
    def getCollectorVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("collectorVersion", collectorVersion)
    def getVersionStatus
        : ZIO[Any, AwsError, zio.aws.databasemigration.model.VersionStatus] =
      AwsError.unwrapOptionField("versionStatus", versionStatus)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getS3BucketName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3BucketName", s3BucketName)
    def getServiceAccessRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceAccessRoleArn", serviceAccessRoleArn)
    def getCollectorHealthCheck: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.CollectorHealthCheck.ReadOnly
    ] = AwsError.unwrapOptionField("collectorHealthCheck", collectorHealthCheck)
    def getLastDataReceived: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastDataReceived", lastDataReceived)
    def getRegisteredDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("registeredDate", registeredDate)
    def getCreatedDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getModifiedDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("modifiedDate", modifiedDate)
    def getInventoryData: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.InventoryData.ReadOnly
    ] = AwsError.unwrapOptionField("inventoryData", inventoryData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.CollectorResponse
  ) extends zio.aws.databasemigration.model.CollectorResponse.ReadOnly {
    override val collectorReferencedId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.collectorReferencedId())
      .map(value => value: String)
    override val collectorName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.collectorName())
      .map(value => value: String)
    override val collectorVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.collectorVersion())
      .map(value => value: String)
    override val versionStatus
        : Optional[zio.aws.databasemigration.model.VersionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.versionStatus())
        .map(value => zio.aws.databasemigration.model.VersionStatus.wrap(value))
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val s3BucketName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.s3BucketName())
      .map(value => value: String)
    override val serviceAccessRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceAccessRoleArn())
      .map(value => value: String)
    override val collectorHealthCheck: Optional[
      zio.aws.databasemigration.model.CollectorHealthCheck.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.collectorHealthCheck())
      .map(value =>
        zio.aws.databasemigration.model.CollectorHealthCheck.wrap(value)
      )
    override val lastDataReceived: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.lastDataReceived())
      .map(value => value: String)
    override val registeredDate: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.registeredDate())
      .map(value => value: String)
    override val createdDate: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.createdDate())
      .map(value => value: String)
    override val modifiedDate: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.modifiedDate())
      .map(value => value: String)
    override val inventoryData
        : Optional[zio.aws.databasemigration.model.InventoryData.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inventoryData())
        .map(value => zio.aws.databasemigration.model.InventoryData.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.CollectorResponse
  ): zio.aws.databasemigration.model.CollectorResponse.ReadOnly = new Wrapper(
    impl
  )
}
