package zio.aws.databasemigration.model
import scala.jdk.CollectionConverters._
sealed trait MessageFormatValue {
  def unwrap: software.amazon.awssdk.services.databasemigration.model.MessageFormatValue
}
object MessageFormatValue {
  def wrap(
      value: software.amazon.awssdk.services.databasemigration.model.MessageFormatValue
  ): zio.aws.databasemigration.model.MessageFormatValue = value match {
    case software.amazon.awssdk.services.databasemigration.model.MessageFormatValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databasemigration.model.MessageFormatValue.JSON =>
      val r = json
      r
    case software.amazon.awssdk.services.databasemigration.model.MessageFormatValue.JSON_UNFORMATTED =>
      val r = `json-unformatted`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.databasemigration.model.MessageFormatValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.MessageFormatValue =
      software.amazon.awssdk.services.databasemigration.model.MessageFormatValue.UNKNOWN_TO_SDK_VERSION
  }
  case object json extends zio.aws.databasemigration.model.MessageFormatValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.MessageFormatValue =
      software.amazon.awssdk.services.databasemigration.model.MessageFormatValue.JSON
  }
  case object `json-unformatted`
      extends zio.aws.databasemigration.model.MessageFormatValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.MessageFormatValue =
      software.amazon.awssdk.services.databasemigration.model.MessageFormatValue.JSON_UNFORMATTED
  }
}
