package zio.aws.databasemigration.model
import scala.jdk.CollectionConverters._
sealed trait EndpointSettingTypeValue {
  def unwrap: software.amazon.awssdk.services.databasemigration.model.EndpointSettingTypeValue
}
object EndpointSettingTypeValue {
  def wrap(
      value: software.amazon.awssdk.services.databasemigration.model.EndpointSettingTypeValue
  ): zio.aws.databasemigration.model.EndpointSettingTypeValue = value match {
    case software.amazon.awssdk.services.databasemigration.model.EndpointSettingTypeValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databasemigration.model.EndpointSettingTypeValue.STRING =>
      val r = string
      r
    case software.amazon.awssdk.services.databasemigration.model.EndpointSettingTypeValue.BOOLEAN =>
      val r = boolean
      r
    case software.amazon.awssdk.services.databasemigration.model.EndpointSettingTypeValue.INTEGER =>
      val r = integer
      r
    case software.amazon.awssdk.services.databasemigration.model.EndpointSettingTypeValue.ENUM =>
      val r = enum
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.databasemigration.model.EndpointSettingTypeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.EndpointSettingTypeValue =
      software.amazon.awssdk.services.databasemigration.model.EndpointSettingTypeValue.UNKNOWN_TO_SDK_VERSION
  }
  case object string
      extends zio.aws.databasemigration.model.EndpointSettingTypeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.EndpointSettingTypeValue =
      software.amazon.awssdk.services.databasemigration.model.EndpointSettingTypeValue.STRING
  }
  case object boolean
      extends zio.aws.databasemigration.model.EndpointSettingTypeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.EndpointSettingTypeValue =
      software.amazon.awssdk.services.databasemigration.model.EndpointSettingTypeValue.BOOLEAN
  }
  case object integer
      extends zio.aws.databasemigration.model.EndpointSettingTypeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.EndpointSettingTypeValue =
      software.amazon.awssdk.services.databasemigration.model.EndpointSettingTypeValue.INTEGER
  }
  case object enum
      extends zio.aws.databasemigration.model.EndpointSettingTypeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.EndpointSettingTypeValue =
      software.amazon.awssdk.services.databasemigration.model.EndpointSettingTypeValue.ENUM
  }
}
