package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteReplicationSubnetGroupRequest(
    replicationSubnetGroupIdentifier: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DeleteReplicationSubnetGroupRequest = {
    import DeleteReplicationSubnetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DeleteReplicationSubnetGroupRequest
      .builder()
      .replicationSubnetGroupIdentifier(
        replicationSubnetGroupIdentifier: java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DeleteReplicationSubnetGroupRequest.ReadOnly =
    zio.aws.databasemigration.model.DeleteReplicationSubnetGroupRequest
      .wrap(buildAwsValue())
}
object DeleteReplicationSubnetGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DeleteReplicationSubnetGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DeleteReplicationSubnetGroupRequest =
      zio.aws.databasemigration.model
        .DeleteReplicationSubnetGroupRequest(replicationSubnetGroupIdentifier)
    def replicationSubnetGroupIdentifier: String
    def getReplicationSubnetGroupIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationSubnetGroupIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DeleteReplicationSubnetGroupRequest
  ) extends zio.aws.databasemigration.model.DeleteReplicationSubnetGroupRequest.ReadOnly {
    override val replicationSubnetGroupIdentifier: String =
      impl.replicationSubnetGroupIdentifier(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DeleteReplicationSubnetGroupRequest
  ): zio.aws.databasemigration.model.DeleteReplicationSubnetGroupRequest.ReadOnly =
    new Wrapper(impl)
}
