package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReplicationSubnetGroup(
    replicationSubnetGroupIdentifier: Optional[String] = Optional.Absent,
    replicationSubnetGroupDescription: Optional[String] = Optional.Absent,
    vpcId: Optional[String] = Optional.Absent,
    subnetGroupStatus: Optional[String] = Optional.Absent,
    subnets: Optional[Iterable[zio.aws.databasemigration.model.Subnet]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ReplicationSubnetGroup = {
    import ReplicationSubnetGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ReplicationSubnetGroup
      .builder()
      .optionallyWith(
        replicationSubnetGroupIdentifier.map(value => value: java.lang.String)
      )(_.replicationSubnetGroupIdentifier)
      .optionallyWith(
        replicationSubnetGroupDescription.map(value => value: java.lang.String)
      )(_.replicationSubnetGroupDescription)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(subnetGroupStatus.map(value => value: java.lang.String))(
        _.subnetGroupStatus
      )
      .optionallyWith(
        subnets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subnets)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ReplicationSubnetGroup.ReadOnly =
    zio.aws.databasemigration.model.ReplicationSubnetGroup.wrap(buildAwsValue())
}
object ReplicationSubnetGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ReplicationSubnetGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.ReplicationSubnetGroup =
      zio.aws.databasemigration.model.ReplicationSubnetGroup(
        replicationSubnetGroupIdentifier.map(value => value),
        replicationSubnetGroupDescription.map(value => value),
        vpcId.map(value => value),
        subnetGroupStatus.map(value => value),
        subnets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def replicationSubnetGroupIdentifier: Optional[String]
    def replicationSubnetGroupDescription: Optional[String]
    def vpcId: Optional[String]
    def subnetGroupStatus: Optional[String]
    def subnets: Optional[List[zio.aws.databasemigration.model.Subnet.ReadOnly]]
    def getReplicationSubnetGroupIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "replicationSubnetGroupIdentifier",
        replicationSubnetGroupIdentifier
      )
    def getReplicationSubnetGroupDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "replicationSubnetGroupDescription",
        replicationSubnetGroupDescription
      )
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getSubnetGroupStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetGroupStatus", subnetGroupStatus)
    def getSubnets: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.Subnet.ReadOnly
    ]] = AwsError.unwrapOptionField("subnets", subnets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ReplicationSubnetGroup
  ) extends zio.aws.databasemigration.model.ReplicationSubnetGroup.ReadOnly {
    override val replicationSubnetGroupIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationSubnetGroupIdentifier())
        .map(value => value: String)
    override val replicationSubnetGroupDescription: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationSubnetGroupDescription())
        .map(value => value: String)
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
    override val subnetGroupStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetGroupStatus())
      .map(value => value: String)
    override val subnets
        : Optional[List[zio.aws.databasemigration.model.Subnet.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subnets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databasemigration.model.Subnet.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ReplicationSubnetGroup
  ): zio.aws.databasemigration.model.ReplicationSubnetGroup.ReadOnly =
    new Wrapper(impl)
}
