package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeCertificatesResponse(
    marker: Optional[String] = Optional.Absent,
    certificates: Optional[
      Iterable[zio.aws.databasemigration.model.Certificate]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesResponse = {
    import DescribeCertificatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        certificates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.certificates)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeCertificatesResponse.ReadOnly =
    zio.aws.databasemigration.model.DescribeCertificatesResponse
      .wrap(buildAwsValue())
}
object DescribeCertificatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeCertificatesResponse =
      zio.aws.databasemigration.model.DescribeCertificatesResponse(
        marker.map(value => value),
        certificates.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def certificates
        : Optional[List[zio.aws.databasemigration.model.Certificate.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getCertificates: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.Certificate.ReadOnly
    ]] = AwsError.unwrapOptionField("certificates", certificates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesResponse
  ) extends zio.aws.databasemigration.model.DescribeCertificatesResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val certificates
        : Optional[List[zio.aws.databasemigration.model.Certificate.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databasemigration.model.Certificate.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesResponse
  ): zio.aws.databasemigration.model.DescribeCertificatesResponse.ReadOnly =
    new Wrapper(impl)
}
