package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.databasemigration.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class OrderableReplicationInstance(
    engineVersion: Optional[String] = Optional.Absent,
    replicationInstanceClass: Optional[String] = Optional.Absent,
    storageType: Optional[String] = Optional.Absent,
    minAllocatedStorage: Optional[Integer] = Optional.Absent,
    maxAllocatedStorage: Optional[Integer] = Optional.Absent,
    defaultAllocatedStorage: Optional[Integer] = Optional.Absent,
    includedAllocatedStorage: Optional[Integer] = Optional.Absent,
    availabilityZones: Optional[Iterable[String]] = Optional.Absent,
    releaseStatus: Optional[
      zio.aws.databasemigration.model.ReleaseStatusValues
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.OrderableReplicationInstance = {
    import OrderableReplicationInstance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.OrderableReplicationInstance
      .builder()
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        replicationInstanceClass.map(value => value: java.lang.String)
      )(_.replicationInstanceClass)
      .optionallyWith(storageType.map(value => value: java.lang.String))(
        _.storageType
      )
      .optionallyWith(
        minAllocatedStorage.map(value => value: java.lang.Integer)
      )(_.minAllocatedStorage)
      .optionallyWith(
        maxAllocatedStorage.map(value => value: java.lang.Integer)
      )(_.maxAllocatedStorage)
      .optionallyWith(
        defaultAllocatedStorage.map(value => value: java.lang.Integer)
      )(_.defaultAllocatedStorage)
      .optionallyWith(
        includedAllocatedStorage.map(value => value: java.lang.Integer)
      )(_.includedAllocatedStorage)
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(releaseStatus.map(value => value.unwrap))(_.releaseStatus)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.OrderableReplicationInstance.ReadOnly =
    zio.aws.databasemigration.model.OrderableReplicationInstance
      .wrap(buildAwsValue())
}
object OrderableReplicationInstance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.OrderableReplicationInstance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.OrderableReplicationInstance =
      zio.aws.databasemigration.model.OrderableReplicationInstance(
        engineVersion.map(value => value),
        replicationInstanceClass.map(value => value),
        storageType.map(value => value),
        minAllocatedStorage.map(value => value),
        maxAllocatedStorage.map(value => value),
        defaultAllocatedStorage.map(value => value),
        includedAllocatedStorage.map(value => value),
        availabilityZones.map(value => value),
        releaseStatus.map(value => value)
      )
    def engineVersion: Optional[String]
    def replicationInstanceClass: Optional[String]
    def storageType: Optional[String]
    def minAllocatedStorage: Optional[Integer]
    def maxAllocatedStorage: Optional[Integer]
    def defaultAllocatedStorage: Optional[Integer]
    def includedAllocatedStorage: Optional[Integer]
    def availabilityZones: Optional[List[String]]
    def releaseStatus
        : Optional[zio.aws.databasemigration.model.ReleaseStatusValues]
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getReplicationInstanceClass: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("replicationInstanceClass", replicationInstanceClass)
    def getStorageType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getMinAllocatedStorage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("minAllocatedStorage", minAllocatedStorage)
    def getMaxAllocatedStorage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxAllocatedStorage", maxAllocatedStorage)
    def getDefaultAllocatedStorage: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("defaultAllocatedStorage", defaultAllocatedStorage)
    def getIncludedAllocatedStorage: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("includedAllocatedStorage", includedAllocatedStorage)
    def getAvailabilityZones: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getReleaseStatus: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ReleaseStatusValues
    ] = AwsError.unwrapOptionField("releaseStatus", releaseStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.OrderableReplicationInstance
  ) extends zio.aws.databasemigration.model.OrderableReplicationInstance.ReadOnly {
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val replicationInstanceClass: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationInstanceClass())
        .map(value => value: String)
    override val storageType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.storageType())
      .map(value => value: String)
    override val minAllocatedStorage: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.minAllocatedStorage())
      .map(value => value: Integer)
    override val maxAllocatedStorage: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxAllocatedStorage())
      .map(value => value: Integer)
    override val defaultAllocatedStorage: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultAllocatedStorage())
        .map(value => value: Integer)
    override val includedAllocatedStorage: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includedAllocatedStorage())
        .map(value => value: Integer)
    override val availabilityZones: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZones())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val releaseStatus
        : Optional[zio.aws.databasemigration.model.ReleaseStatusValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.releaseStatus())
        .map(value =>
          zio.aws.databasemigration.model.ReleaseStatusValues.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.OrderableReplicationInstance
  ): zio.aws.databasemigration.model.OrderableReplicationInstance.ReadOnly =
    new Wrapper(impl)
}
