package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.databasemigration.model.primitives.{SecretString, Integer}
import scala.jdk.CollectionConverters._
final case class RedisSettings(
    serverName: String,
    port: Integer,
    sslSecurityProtocol: Optional[
      zio.aws.databasemigration.model.SslSecurityProtocolValue
    ] = Optional.Absent,
    authType: Optional[zio.aws.databasemigration.model.RedisAuthTypeValue] =
      Optional.Absent,
    authUserName: Optional[String] = Optional.Absent,
    authPassword: Optional[SecretString] = Optional.Absent,
    sslCaCertificateArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.RedisSettings = {
    import RedisSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.RedisSettings
      .builder()
      .serverName(serverName: java.lang.String)
      .port(port: java.lang.Integer)
      .optionallyWith(sslSecurityProtocol.map(value => value.unwrap))(
        _.sslSecurityProtocol
      )
      .optionallyWith(authType.map(value => value.unwrap))(_.authType)
      .optionallyWith(authUserName.map(value => value: java.lang.String))(
        _.authUserName
      )
      .optionallyWith(
        authPassword.map(value => SecretString.unwrap(value): java.lang.String)
      )(_.authPassword)
      .optionallyWith(
        sslCaCertificateArn.map(value => value: java.lang.String)
      )(_.sslCaCertificateArn)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.RedisSettings.ReadOnly =
    zio.aws.databasemigration.model.RedisSettings.wrap(buildAwsValue())
}
object RedisSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.RedisSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.RedisSettings =
      zio.aws.databasemigration.model.RedisSettings(
        serverName,
        port,
        sslSecurityProtocol.map(value => value),
        authType.map(value => value),
        authUserName.map(value => value),
        authPassword.map(value => value),
        sslCaCertificateArn.map(value => value)
      )
    def serverName: String
    def port: Integer
    def sslSecurityProtocol
        : Optional[zio.aws.databasemigration.model.SslSecurityProtocolValue]
    def authType: Optional[zio.aws.databasemigration.model.RedisAuthTypeValue]
    def authUserName: Optional[String]
    def authPassword: Optional[SecretString]
    def sslCaCertificateArn: Optional[String]
    def getServerName: ZIO[Any, Nothing, String] = ZIO.succeed(serverName)
    def getPort: ZIO[Any, Nothing, Integer] = ZIO.succeed(port)
    def getSslSecurityProtocol: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.SslSecurityProtocolValue
    ] = AwsError.unwrapOptionField("sslSecurityProtocol", sslSecurityProtocol)
    def getAuthType: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.RedisAuthTypeValue
    ] = AwsError.unwrapOptionField("authType", authType)
    def getAuthUserName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("authUserName", authUserName)
    def getAuthPassword: ZIO[Any, AwsError, SecretString] =
      AwsError.unwrapOptionField("authPassword", authPassword)
    def getSslCaCertificateArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sslCaCertificateArn", sslCaCertificateArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.RedisSettings
  ) extends zio.aws.databasemigration.model.RedisSettings.ReadOnly {
    override val serverName: String = impl.serverName(): String
    override val port: Integer = impl.port(): Integer
    override val sslSecurityProtocol
        : Optional[zio.aws.databasemigration.model.SslSecurityProtocolValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sslSecurityProtocol())
        .map(value =>
          zio.aws.databasemigration.model.SslSecurityProtocolValue.wrap(value)
        )
    override val authType
        : Optional[zio.aws.databasemigration.model.RedisAuthTypeValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authType())
        .map(value =>
          zio.aws.databasemigration.model.RedisAuthTypeValue.wrap(value)
        )
    override val authUserName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.authUserName())
      .map(value => value: String)
    override val authPassword: Optional[SecretString] = zio.aws.core.internal
      .optionalFromNullable(impl.authPassword())
      .map(value =>
        zio.aws.databasemigration.model.primitives.SecretString(value)
      )
    override val sslCaCertificateArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sslCaCertificateArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.RedisSettings
  ): zio.aws.databasemigration.model.RedisSettings.ReadOnly = new Wrapper(impl)
}
