package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeAccountAttributesResponse(
    accountQuotas: Optional[
      Iterable[zio.aws.databasemigration.model.AccountQuota]
    ] = Optional.Absent,
    uniqueAccountIdentifier: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeAccountAttributesResponse = {
    import DescribeAccountAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeAccountAttributesResponse
      .builder()
      .optionallyWith(
        accountQuotas.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accountQuotas)
      .optionallyWith(
        uniqueAccountIdentifier.map(value => value: java.lang.String)
      )(_.uniqueAccountIdentifier)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeAccountAttributesResponse.ReadOnly =
    zio.aws.databasemigration.model.DescribeAccountAttributesResponse
      .wrap(buildAwsValue())
}
object DescribeAccountAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeAccountAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeAccountAttributesResponse =
      zio.aws.databasemigration.model.DescribeAccountAttributesResponse(
        accountQuotas.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        uniqueAccountIdentifier.map(value => value)
      )
    def accountQuotas
        : Optional[List[zio.aws.databasemigration.model.AccountQuota.ReadOnly]]
    def uniqueAccountIdentifier: Optional[String]
    def getAccountQuotas: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.AccountQuota.ReadOnly
    ]] = AwsError.unwrapOptionField("accountQuotas", accountQuotas)
    def getUniqueAccountIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("uniqueAccountIdentifier", uniqueAccountIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeAccountAttributesResponse
  ) extends zio.aws.databasemigration.model.DescribeAccountAttributesResponse.ReadOnly {
    override val accountQuotas: Optional[
      List[zio.aws.databasemigration.model.AccountQuota.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.accountQuotas())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.AccountQuota.wrap(item)
        }.toList
      )
    override val uniqueAccountIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.uniqueAccountIdentifier())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeAccountAttributesResponse
  ): zio.aws.databasemigration.model.DescribeAccountAttributesResponse.ReadOnly =
    new Wrapper(impl)
}
